/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.internal.util;

import android.content.ClipData;
import android.content.ComponentName;
import android.content.Intent;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;

public class ObjectToStringUtil {
    public static String bundleToString(Bundle bundle) {
        if (bundle == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder(128);
        b.append("Bundle[{");
        ObjectToStringUtil.bundleToShortString(bundle, b);
        b.append("}]");
        return b.toString();
    }

    public static String intentToString(Intent intent) {
        if (intent == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder(128);
        b.append("Intent { ");
        ObjectToStringUtil.intentToShortString(intent, b);
        b.append(" }");
        return b.toString();
    }

    private static void bundleToShortString(Bundle bundle, StringBuilder b) {
        boolean first = true;
        for (String key : bundle.keySet()) {
            if (!first) {
                b.append(", ");
            }
            b.append(key).append('=');
            Object value = bundle.get(key);
            if (value instanceof int[]) {
                b.append(Arrays.toString((int[])value));
            } else if (value instanceof byte[]) {
                b.append(Arrays.toString((byte[])value));
            } else if (value instanceof boolean[]) {
                b.append(Arrays.toString((boolean[])value));
            } else if (value instanceof short[]) {
                b.append(Arrays.toString((short[])value));
            } else if (value instanceof long[]) {
                b.append(Arrays.toString((long[])value));
            } else if (value instanceof float[]) {
                b.append(Arrays.toString((float[])value));
            } else if (value instanceof double[]) {
                b.append(Arrays.toString((double[])value));
            } else if (value instanceof String[]) {
                b.append(Arrays.toString((String[])value));
            } else if (value instanceof CharSequence[]) {
                b.append(Arrays.toString((CharSequence[])value));
            } else if (value instanceof Parcelable[]) {
                b.append(Arrays.toString((Parcelable[])value));
            } else if (value instanceof Bundle) {
                b.append(ObjectToStringUtil.bundleToString((Bundle)value));
            } else {
                b.append(value);
            }
            first = false;
        }
    }

    private static void intentToShortString(Intent intent, StringBuilder b) {
        Intent mSelector;
        Bundle mExtras;
        ClipData mClipData;
        Rect mSourceBounds;
        ComponentName mComponent;
        String mPackage;
        int mFlags;
        String mType;
        Uri mData;
        Set mCategories;
        boolean first = true;
        String mAction = intent.getAction();
        if (mAction != null) {
            b.append("act=").append(mAction);
            first = false;
        }
        if ((mCategories = intent.getCategories()) != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("cat=[");
            boolean firstCategory = true;
            for (String c : mCategories) {
                if (!firstCategory) {
                    b.append(',');
                }
                b.append(c);
                firstCategory = false;
            }
            b.append("]");
        }
        if ((mData = intent.getData()) != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("dat=");
            if (Build.VERSION.SDK_INT >= 14) {
                b.append(ObjectToStringUtil.uriToSafeString(mData));
            } else {
                String scheme = mData.getScheme();
                if (scheme != null) {
                    if (scheme.equalsIgnoreCase("tel")) {
                        b.append("tel:xxx-xxx-xxxx");
                    } else if (scheme.equalsIgnoreCase("smsto")) {
                        b.append("smsto:xxx-xxx-xxxx");
                    } else {
                        b.append(mData);
                    }
                } else {
                    b.append(mData);
                }
            }
        }
        if ((mType = intent.getType()) != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("typ=").append(mType);
        }
        if ((mFlags = intent.getFlags()) != 0) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("flg=0x").append(Integer.toHexString(mFlags));
        }
        if ((mPackage = intent.getPackage()) != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("pkg=").append(mPackage);
        }
        if ((mComponent = intent.getComponent()) != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("cmp=").append(mComponent.flattenToShortString());
        }
        if ((mSourceBounds = intent.getSourceBounds()) != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("bnds=").append(mSourceBounds.toShortString());
        }
        if (Build.VERSION.SDK_INT >= 16 && (mClipData = intent.getClipData()) != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("(has clip)");
        }
        if ((mExtras = intent.getExtras()) != null) {
            if (!first) {
                b.append(' ');
            }
            b.append("extras={");
            ObjectToStringUtil.bundleToShortString(mExtras, b);
            b.append('}');
        }
        if (Build.VERSION.SDK_INT >= 15 && (mSelector = intent.getSelector()) != null) {
            b.append(" sel=");
            ObjectToStringUtil.intentToShortString(mSelector, b);
            b.append("}");
        }
    }

    private static String uriToSafeString(Uri uri) {
        if (Build.VERSION.SDK_INT >= 14) {
            try {
                Method toSafeString = Uri.class.getDeclaredMethod("toSafeString", new Class[0]);
                toSafeString.setAccessible(true);
                return (String)toSafeString.invoke((Object)uri, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return uri.toString();
    }
}

