/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.printer;

import android.util.Log;
import com.elvishew.xlog.printer.Printer;

public class AndroidPrinter
implements Printer {
    static final int DEFAULT_MAX_CHUNK_SIZE = 4063;
    private int maxChunkSize;

    public AndroidPrinter() {
        this(4063);
    }

    public AndroidPrinter(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    @Override
    public void println(int logLevel, String tag, String msg) {
        if (msg.length() <= this.maxChunkSize) {
            this.printChunk(logLevel, tag, msg);
            return;
        }
        int msgLength = msg.length();
        int start = 0;
        while (start < msgLength) {
            int end = AndroidPrinter.adjustEnd(msg, start, Math.min(start + this.maxChunkSize, msgLength));
            this.printChunk(logLevel, tag, msg.substring(start, end));
            start = end;
        }
    }

    static int adjustEnd(String msg, int start, int originEnd) {
        if (originEnd == msg.length()) {
            return originEnd;
        }
        if (msg.charAt(originEnd) == '\n') {
            return originEnd;
        }
        for (int last = originEnd - 1; start < last; --last) {
            if (msg.charAt(last) != '\n') continue;
            return last + 1;
        }
        return originEnd;
    }

    void printChunk(int logLevel, String tag, String msg) {
        Log.println((int)logLevel, (String)tag, (String)msg);
    }
}

