/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.internal.util;

import com.elvishew.xlog.XLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;

public class StackTraceUtil {
    private static final String XLOG_STACK_TRACE_ORIGIN;

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static StackTraceElement[] getCroppedRealStackTrack(StackTraceElement[] stackTrace, String stackTraceOrigin, int maxDepth) {
        return StackTraceUtil.cropStackTrace(StackTraceUtil.getRealStackTrack(stackTrace, stackTraceOrigin), maxDepth);
    }

    private static StackTraceElement[] getRealStackTrack(StackTraceElement[] stackTrace, String stackTraceOrigin) {
        int ignoreDepth = 0;
        int allDepth = stackTrace.length;
        for (int i = allDepth - 1; i >= 0; --i) {
            String className = stackTrace[i].getClassName();
            if (!className.startsWith(XLOG_STACK_TRACE_ORIGIN) && (stackTraceOrigin == null || !className.startsWith(stackTraceOrigin))) continue;
            ignoreDepth = i + 1;
            break;
        }
        int realDepth = allDepth - ignoreDepth;
        StackTraceElement[] realStack = new StackTraceElement[realDepth];
        System.arraycopy(stackTrace, ignoreDepth, realStack, 0, realDepth);
        return realStack;
    }

    private static StackTraceElement[] cropStackTrace(StackTraceElement[] callStack, int maxDepth) {
        int realDepth = callStack.length;
        if (maxDepth > 0) {
            realDepth = Math.min(maxDepth, realDepth);
        }
        StackTraceElement[] realStack = new StackTraceElement[realDepth];
        System.arraycopy(callStack, 0, realStack, 0, realDepth);
        return realStack;
    }

    static {
        String xlogClassName = XLog.class.getName();
        XLOG_STACK_TRACE_ORIGIN = xlogClassName.substring(0, xlogClassName.lastIndexOf(46) + 1);
    }
}

