/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.printer.file;

import com.elvishew.xlog.flattener.Flattener;
import com.elvishew.xlog.internal.DefaultsFactory;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.file.backup.BackupStrategy;
import com.elvishew.xlog.printer.file.clean.CleanStrategy;
import com.elvishew.xlog.printer.file.naming.FileNameGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class FilePrinter
implements Printer {
    private static final boolean USE_WORKER = true;
    private final String folderPath;
    private final FileNameGenerator fileNameGenerator;
    private final BackupStrategy backupStrategy;
    private final CleanStrategy cleanStrategy;
    private Flattener flattener;
    private Writer writer;
    private volatile Worker worker;

    FilePrinter(Builder builder) {
        this.folderPath = builder.folderPath;
        this.fileNameGenerator = builder.fileNameGenerator;
        this.backupStrategy = builder.backupStrategy;
        this.cleanStrategy = builder.cleanStrategy;
        this.flattener = builder.flattener;
        this.writer = new Writer();
        this.worker = new Worker();
        this.checkLogFolder();
    }

    private void checkLogFolder() {
        File folder = new File(this.folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    @Override
    public void println(int logLevel, String tag, String msg) {
        if (!this.worker.isStarted()) {
            this.worker.start();
        }
        this.worker.enqueue(new LogItem(logLevel, tag, msg));
    }

    private void doPrintln(int logLevel, String tag, String msg) {
        File lastFile;
        String lastFileName = this.writer.getLastFileName();
        if (lastFileName == null || this.fileNameGenerator.isFileNameChangeable()) {
            String newFileName = this.fileNameGenerator.generateFileName(logLevel, System.currentTimeMillis());
            if (newFileName == null || newFileName.trim().length() == 0) {
                throw new IllegalArgumentException("File name should not be empty.");
            }
            if (!newFileName.equals(lastFileName)) {
                if (this.writer.isOpened()) {
                    this.writer.close();
                }
                this.cleanLogFilesIfNecessary();
                if (!this.writer.open(newFileName)) {
                    return;
                }
                lastFileName = newFileName;
            }
        }
        if (this.backupStrategy.shouldBackup(lastFile = this.writer.getFile())) {
            this.writer.close();
            File backupFile = new File(this.folderPath, lastFileName + ".bak");
            if (backupFile.exists()) {
                backupFile.delete();
            }
            lastFile.renameTo(backupFile);
            if (!this.writer.open(lastFileName)) {
                return;
            }
        }
        String flattenedLog = this.flattener.flatten(logLevel, tag, msg).toString();
        this.writer.appendLog(flattenedLog);
    }

    private void cleanLogFilesIfNecessary() {
        File[] files;
        File logDir = new File(this.folderPath);
        for (File file : files = logDir.listFiles()) {
            if (!this.cleanStrategy.shouldClean(file)) continue;
            file.delete();
        }
    }

    private class Writer {
        private String lastFileName;
        private File logFile;
        private BufferedWriter bufferedWriter;

        private Writer() {
        }

        boolean isOpened() {
            return this.bufferedWriter != null;
        }

        String getLastFileName() {
            return this.lastFileName;
        }

        File getFile() {
            return this.logFile;
        }

        boolean open(String newFileName) {
            this.lastFileName = newFileName;
            this.logFile = new File(FilePrinter.this.folderPath, newFileName);
            if (!this.logFile.exists()) {
                try {
                    File parent = this.logFile.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    this.logFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.lastFileName = null;
                    this.logFile = null;
                    return false;
                }
            }
            try {
                this.bufferedWriter = new BufferedWriter(new FileWriter(this.logFile, true));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lastFileName = null;
                this.logFile = null;
                return false;
            }
            return true;
        }

        boolean close() {
            if (this.bufferedWriter != null) {
                try {
                    this.bufferedWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.bufferedWriter = null;
                    this.lastFileName = null;
                    this.logFile = null;
                }
            }
            return true;
        }

        void appendLog(String flattenedLog) {
            try {
                this.bufferedWriter.write(flattenedLog);
                this.bufferedWriter.newLine();
                this.bufferedWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class Worker
    implements Runnable {
        private BlockingQueue<LogItem> logs = new LinkedBlockingQueue<LogItem>();
        private volatile boolean started;

        private Worker() {
        }

        void enqueue(LogItem log) {
            try {
                this.logs.put(log);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isStarted() {
            Worker worker = this;
            synchronized (worker) {
                return this.started;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            Worker worker = this;
            synchronized (worker) {
                new Thread(this).start();
                this.started = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LogItem log;
                while ((log = this.logs.take()) != null) {
                    FilePrinter.this.doPrintln(log.level, log.tag, log.msg);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Worker worker = this;
                synchronized (worker) {
                    this.started = false;
                }
            }
        }
    }

    private class LogItem {
        int level;
        String tag;
        String msg;

        LogItem(int level, String tag, String msg) {
            this.level = level;
            this.tag = tag;
            this.msg = msg;
        }
    }

    public static class Builder {
        String folderPath;
        FileNameGenerator fileNameGenerator;
        BackupStrategy backupStrategy;
        CleanStrategy cleanStrategy;
        Flattener flattener;

        public Builder(String folderPath) {
            this.folderPath = folderPath;
        }

        public Builder fileNameGenerator(FileNameGenerator fileNameGenerator) {
            this.fileNameGenerator = fileNameGenerator;
            return this;
        }

        public Builder backupStrategy(BackupStrategy backupStrategy) {
            this.backupStrategy = backupStrategy;
            return this;
        }

        public Builder cleanStrategy(CleanStrategy cleanStrategy) {
            this.cleanStrategy = cleanStrategy;
            return this;
        }

        public Builder logFlattener(Flattener flattener) {
            this.flattener = flattener;
            return this;
        }

        public FilePrinter build() {
            this.fillEmptyFields();
            return new FilePrinter(this);
        }

        private void fillEmptyFields() {
            if (this.fileNameGenerator == null) {
                this.fileNameGenerator = DefaultsFactory.createFileNameGenerator();
            }
            if (this.backupStrategy == null) {
                this.backupStrategy = DefaultsFactory.createBackupStrategy();
            }
            if (this.cleanStrategy == null) {
                this.cleanStrategy = DefaultsFactory.createCleanStrategy();
            }
            if (this.flattener == null) {
                this.flattener = DefaultsFactory.createFlattener();
            }
        }
    }
}

