/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.formatter.stacktrace;

import com.elvishew.xlog.formatter.stacktrace.StackTraceFormatter;
import com.elvishew.xlog.internal.SystemCompat;

public class DefaultStackTraceFormatter
implements StackTraceFormatter {
    @Override
    public String format(StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder(256);
        if (stackTrace == null || stackTrace.length == 0) {
            return null;
        }
        if (stackTrace.length == 1) {
            return "\t\u2500 " + stackTrace[0].toString();
        }
        int N = stackTrace.length;
        for (int i = 0; i < N; ++i) {
            if (i != N - 1) {
                sb.append("\t\u251c ");
                sb.append(stackTrace[i].toString());
                sb.append(SystemCompat.lineSeparator);
                continue;
            }
            sb.append("\t\u2514 ");
            sb.append(stackTrace[i].toString());
        }
        return sb.toString();
    }
}

