/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog;

import com.elvishew.xlog.XLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LogUtils {
    public static String formatJson(String json) {
        XLog.assertInitialization();
        return XLog.sLogConfiguration.jsonFormatter.format(json);
    }

    public static String formatXml(String xml) {
        XLog.assertInitialization();
        return XLog.sLogConfiguration.xmlFormatter.format(xml);
    }

    public static String formatThrowable(Throwable throwable) {
        XLog.assertInitialization();
        return XLog.sLogConfiguration.throwableFormatter.format(throwable);
    }

    public static String formatThread(Thread thread) {
        XLog.assertInitialization();
        return XLog.sLogConfiguration.threadFormatter.format(thread);
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace) {
        XLog.assertInitialization();
        return XLog.sLogConfiguration.stackTraceFormatter.format(stackTrace);
    }

    public static String addBorder(String[] segments) {
        XLog.assertInitialization();
        return XLog.sLogConfiguration.borderFormatter.format(segments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(String folderPath, String zipFilePath) throws IOException {
        File folder = new File(folderPath);
        if (!folder.exists() || !folder.isDirectory()) {
            throw new IOException("Folder " + folderPath + " does't exist or isn't a directory");
        }
        File zipFile = new File(zipFilePath);
        if (!zipFile.exists()) {
            File zipFolder = zipFile.getParentFile();
            if (!zipFolder.exists() && !zipFolder.mkdirs()) {
                throw new IOException("Zip folder " + zipFolder.getAbsolutePath() + " not created");
            }
            if (!zipFile.createNewFile()) {
                throw new IOException("Zip file " + zipFilePath + " not created");
            }
        }
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
        try {
            int BUFFER_SIZE = 8192;
            byte[] buffer = new byte[8192];
            for (String fileName : folder.list()) {
                File file;
                if (fileName.equals(".") || fileName.equals("..") || !(file = new File(folder, fileName)).isFile()) continue;
                FileInputStream fis = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(fis, 8192);
                try {
                    int count;
                    ZipEntry entry = new ZipEntry(fileName);
                    zos.putNextEntry(entry);
                    while ((count = bis.read(buffer, 0, 8192)) != -1) {
                        zos.write(buffer, 0, count);
                    }
                }
                finally {
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            try {
                zos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

