/*
 * Decompiled with CFR 0.152.
 */
package com.emaraic.jdlib;

import com.emaraic.utils.FaceDescriptor;
import com.emaraic.utils.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

public class Jdlib {
    private String facialLandmarksModelPath;
    private String faceEmbeddingModelPath;

    public Jdlib(String facialLandmarksModelPath, String faceEmbeddingModelPath) {
        this.facialLandmarksModelPath = facialLandmarksModelPath;
        this.faceEmbeddingModelPath = faceEmbeddingModelPath;
        this.loadLib();
    }

    public Jdlib(String facialLandmarksModelPath) {
        this.facialLandmarksModelPath = facialLandmarksModelPath;
        this.faceEmbeddingModelPath = null;
        this.loadLib();
    }

    private native long getFaceDectorHandler();

    private native long getShapePredictorHandler(String var1);

    private native long getFaceEmbeddingHandler(String var1);

    private native ArrayList<Rectangle> faceDetect(long var1, byte[] var3, int var4, int var5);

    private native ArrayList<FaceDescriptor> getFacialLandmarks(long var1, long var3, byte[] var5, int var6, int var7);

    private native ArrayList<FaceDescriptor> getFaceEmbeddings(long var1, long var3, long var5, byte[] var7, int var8, int var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLib() {
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        String name = System.mapLibraryName("Jdlib");
        String libpath = "";
        if (os.contains("linux")) {
            libpath = "/native" + File.separator + "linux" + File.separator + name;
        } else if (os.contains("mac")) {
            libpath = "/native" + File.separator + "macosx" + File.separator + name;
        } else {
            throw new UnsupportedOperationException(os + " is not supported. Try to recompile Jdlib on your machine and then use it.");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = Jdlib.class.getResourceAsStream(libpath);
            File fileOut = File.createTempFile(name, "");
            outputStream = new FileOutputStream(fileOut);
            byte[] buffer = new byte[1024];
            int read = -1;
            while ((read = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, read);
            }
            outputStream.close();
            inputStream.close();
            System.load(fileOut.toString());
        }
        catch (Exception e) {
            System.err.println("Error During Loading Lib!");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    System.err.println("Error During Closing Input Stream!!");
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    System.err.println("Error During Closing Output Stream!!");
                }
            }
        }
    }

    public ArrayList<Rectangle> detectFace(BufferedImage img) {
        Image image = new Image(img);
        ArrayList<Rectangle> data = this.faceDetect(this.getFaceDectorHandler(), image.pixels, image.height, image.width);
        if (data == null) {
            System.err.println("Jdlib | detectFace | Null data!!");
            data = new ArrayList(Collections.EMPTY_LIST);
        }
        return data;
    }

    public ArrayList<FaceDescriptor> getFaceLandmarks(BufferedImage img) {
        Image image = new Image(img);
        ArrayList<FaceDescriptor> data = this.getFacialLandmarks(this.getShapePredictorHandler(this.facialLandmarksModelPath), this.getFaceDectorHandler(), image.pixels, image.height, image.width);
        if (data == null) {
            System.err.println("Jdlib | getFaceLandmarks | Null data!!");
            data = new ArrayList(Collections.EMPTY_LIST);
        }
        return data;
    }

    public ArrayList<FaceDescriptor> getFaceEmbeddings(BufferedImage img) {
        if (this.facialLandmarksModelPath == null) {
            throw new IllegalArgumentException("Path to face embedding model isn't provided!");
        }
        Image image = new Image(img);
        ArrayList<FaceDescriptor> data = this.getFaceEmbeddings(this.getFaceEmbeddingHandler(this.faceEmbeddingModelPath), this.getShapePredictorHandler(this.facialLandmarksModelPath), this.getFaceDectorHandler(), image.pixels, image.height, image.width);
        if (data == null) {
            System.err.println("Jdlib | getFaceEmbeddings | Null data!!");
            data = new ArrayList(Collections.EMPTY_LIST);
        }
        return data;
    }
}

