/*
 * Decompiled with CFR 0.152.
 */
package com.emaraic.utils;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class Image {
    public final int width;
    public final int height;
    private final boolean hasAlphaChannel;
    private int pixelLength;
    public final byte[] pixels;

    public Image(BufferedImage image) {
        this.pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.hasAlphaChannel = image.getAlphaRaster() != null;
        this.pixelLength = 3;
        if (this.hasAlphaChannel) {
            this.pixelLength = 4;
        }
    }

    short[] getRGB(int x, int y) {
        int pos = y * this.pixelLength * this.width + x * this.pixelLength;
        short[] rgb = new short[4];
        if (this.hasAlphaChannel) {
            rgb[3] = (short)(this.pixels[pos++] & 0xFF);
        }
        rgb[2] = (short)(this.pixels[pos++] & 0xFF);
        rgb[1] = (short)(this.pixels[pos++] & 0xFF);
        rgb[0] = (short)(this.pixels[pos++] & 0xFF);
        return rgb;
    }
}

