/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.config;

import android.app.Application;
import android.content.SharedPreferences;
import com.emarsys.config.ConfigStorageKeys;
import com.emarsys.config.EmarsysConfig;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/emarsys/config/ConfigLoader;", "", "()V", "loadConfigFromSharedPref", "Lcom/emarsys/config/EmarsysConfig$Builder;", "application", "Landroid/app/Application;", "sharedPreferenceSource", "", "emarsys-sdk_release"})
public final class ConfigLoader {
    @NotNull
    public final EmarsysConfig.Builder loadConfigFromSharedPref(@NotNull Application application, @NotNull String sharedPreferenceSource) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)sharedPreferenceSource, (String)"sharedPreferenceSource");
        SharedPreferences sharedPreferences2 = application.getSharedPreferences(sharedPreferenceSource, 0);
        String appCode = sharedPreferences2.getString(ConfigStorageKeys.MOBILE_ENGAGE_APPLICATION_CODE.name(), null);
        String merchantId = sharedPreferences2.getString(ConfigStorageKeys.PREDICT_MERCHANT_ID.name(), null);
        boolean disableAutomaticPushSending = sharedPreferences2.getBoolean(ConfigStorageKeys.ANDROID_DISABLE_AUTOMATIC_PUSH_TOKEN_SENDING.name(), false);
        Set sharedPackages = sharedPreferences2.getStringSet(ConfigStorageKeys.ANDROID_SHARED_PACKAGE_NAMES.name(), (Set)new LinkedHashSet());
        String secret = sharedPreferences2.getString(ConfigStorageKeys.ANDROID_SHARED_SECRET.name(), null);
        boolean enableVerboseLogging = sharedPreferences2.getBoolean(ConfigStorageKeys.ANDROID_VERBOSE_CONSOLE_LOGGING_ENABLED.name(), false);
        EmarsysConfig.Builder builder = new EmarsysConfig.Builder().application(application).applicationCode(appCode).merchantId(merchantId);
        if (disableAutomaticPushSending) {
            builder.disableAutomaticPushTokenSending();
        }
        if (enableVerboseLogging) {
            builder.enableVerboseConsoleLogging();
        }
        if (!((collection = (Collection)sharedPackages) == null || collection.isEmpty())) {
            builder.sharedPackageNames(CollectionsKt.toList((Iterable)sharedPackages));
        }
        if (secret != null) {
            builder.sharedSecret(secret);
        }
        return builder;
    }
}

