/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.logger.ce;

import cats.Applicative;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.IOLocal;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.mtl.Local;
import com.emarsys.logger.Logging;
import com.emarsys.logger.LoggingContext;
import com.emarsys.logger.ce.CatsEffectLogging$;
import com.emarsys.logger.internal.LoggingContextUtil$;
import com.emarsys.logger.levels.LogLevel;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

public class CatsEffectLogging<F>
implements Logging<F> {
    private final Logger logger;
    private final Sync<F> evidence$1;

    public static <F> Object createEffectLogger(String string, Sync<F> sync) {
        return CatsEffectLogging$.MODULE$.createEffectLogger(string, sync);
    }

    public static <F, G> Object createEffectLoggerG(String string, Sync<F> sync, Sync<G> sync2) {
        return CatsEffectLogging$.MODULE$.createEffectLoggerG(string, sync, sync2);
    }

    public static IO<Local<IO, LoggingContext>> createIOLocalContext(LoggingContext loggingContext) {
        return CatsEffectLogging$.MODULE$.createIOLocalContext(loggingContext);
    }

    public <F> CatsEffectLogging(Logger logger, Sync<F> evidence$1) {
        this.logger = logger;
        this.evidence$1 = evidence$1;
    }

    public F log(LogLevel level, String msg, LoggingContext ctx) {
        return (F)package$.MODULE$.Sync().apply(this.evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.log$$anonfun$1(level, msg, ctx)));
    }

    private static final Marker marker$lzyINIT1$1(LoggingContext ctx$1, LazyRef marker$lzy1$1) {
        Marker marker;
        LazyRef lazyRef = marker$lzy1$1;
        synchronized (lazyRef) {
            marker = (Marker)(marker$lzy1$1.initialized() ? marker$lzy1$1.value() : marker$lzy1$1.initialize((Object)LoggingContextUtil$.MODULE$.toMarker(ctx$1)));
        }
        return marker;
    }

    private static final Marker marker$1(LoggingContext ctx$3, LazyRef marker$lzy1$2) {
        return (Marker)(marker$lzy1$2.initialized() ? marker$lzy1$2.value() : CatsEffectLogging.marker$lzyINIT1$1(ctx$3, marker$lzy1$2));
    }

    private final void log$$anonfun$1(LogLevel level$1, String msg$1, LoggingContext ctx$2) {
        LazyRef lazyRef = new LazyRef();
        LogLevel logLevel = level$1;
        LogLevel logLevel2 = LogLevel.INFO;
        LogLevel logLevel3 = logLevel;
        if (!(logLevel2 != null ? !logLevel2.equals(logLevel3) : logLevel3 != null)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(CatsEffectLogging.marker$1(ctx$2, lazyRef), msg$1);
            }
        } else {
            LogLevel logLevel4 = LogLevel.DEBUG;
            LogLevel logLevel5 = logLevel;
            if (!(logLevel4 != null ? !logLevel4.equals(logLevel5) : logLevel5 != null)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(CatsEffectLogging.marker$1(ctx$2, lazyRef), msg$1);
                }
            } else {
                LogLevel logLevel6 = LogLevel.WARN;
                LogLevel logLevel7 = logLevel;
                if (!(logLevel6 != null ? !logLevel6.equals(logLevel7) : logLevel7 != null)) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn(CatsEffectLogging.marker$1(ctx$2, lazyRef), msg$1);
                    }
                } else {
                    LogLevel logLevel8 = LogLevel.ERROR;
                    LogLevel logLevel9 = logLevel;
                    if (!(logLevel8 != null ? !logLevel8.equals(logLevel9) : logLevel9 != null)) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error(CatsEffectLogging.marker$1(ctx$2, lazyRef), msg$1);
                        }
                    } else {
                        throw new MatchError((Object)logLevel);
                    }
                }
            }
        }
    }

    public static class IOLocalLocal
    implements Local<IO, LoggingContext> {
        private final IOLocal<LoggingContext> localLoggingContext;

        public IOLocalLocal(IOLocal<LoggingContext> localLoggingContext) {
            this.localLoggingContext = localLoggingContext;
        }

        public Applicative<IO> applicative() {
            return (Applicative)Predef$.MODULE$.implicitly((Object)IO$.MODULE$.asyncForIO());
        }

        public <E2> IO<E2> ask() {
            return this.localLoggingContext.get();
        }

        public <A> IO<A> local(IO<A> fa, Function1<LoggingContext, LoggingContext> f) {
            return this.localLoggingContext.get().flatMap((Function1 & Serializable)originalLoggingContext -> this.localLoggingContext.set(f.apply(originalLoggingContext)).$times$greater(fa).guarantee(this.localLoggingContext.set(originalLoggingContext)).map((Function1 & Serializable)result -> result));
        }
    }
}

