package com.emarsys.logger

import com.emarsys.logger.loggable.{LoggableEncoder, LoggableObject}

case class LoggingContext(transactionId: String, logData: LoggableObject) {
  import com.emarsys.logger.syntax._

  def <>[T: LoggableEncoder](param: (String, T)): LoggingContext = addParameter(param)

  def addParameter[T: LoggableEncoder](param: (String, T)): LoggingContext = {
    val encodedParam = param._1 -> param._2.toLoggable
    copy(logData = LoggableObject(logData.obj + encodedParam))
  }
}

object LoggingContext {
  def apply(transactionId: String): LoggingContext = LoggingContext(transactionId, LoggableObject.empty)
}
