/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.a2a.server.support;

import com.embabel.agent.a2a.server.AgentCardHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.a2a.spec.AgentCard;
import io.a2a.spec.CancelTaskRequest;
import io.a2a.spec.GetTaskRequest;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.JSONRPCErrorResponse;
import io.a2a.spec.NonStreamingJSONRPCRequest;
import io.a2a.spec.SendMessageRequest;
import io.a2a.spec.SendStreamingMessageRequest;
import io.a2a.spec.StreamingJSONRPCRequest;
import jakarta.servlet.ServletRequest;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001e\u0010\u0015\u001a\u00020\u00012\u0014\b\u0001\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u0017H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/embabel/agent/a2a/server/support/AgentCardHandlerWebFacade;", "", "agentCardHandler", "Lcom/embabel/agent/a2a/server/AgentCardHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/embabel/agent/a2a/server/AgentCardHandler;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getAgentCardHandler", "()Lcom/embabel/agent/a2a/server/AgentCardHandler;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "agentCard", "Lorg/springframework/http/ResponseEntity;", "Lio/a2a/spec/AgentCard;", "servletRequest", "Ljakarta/servlet/ServletRequest;", "handleJsonRpc", "requestMap", "", "", "embabel-agent-a2a"})
final class AgentCardHandlerWebFacade {
    @NotNull
    private final AgentCardHandler agentCardHandler;
    @NotNull
    private final ObjectMapper objectMapper;
    private final Logger logger;

    public AgentCardHandlerWebFacade(@NotNull AgentCardHandler agentCardHandler, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)agentCardHandler, (String)"agentCardHandler");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.agentCardHandler = agentCardHandler;
        this.objectMapper = objectMapper;
        this.logger = LoggerFactory.getLogger(AgentCardHandlerWebFacade.class);
    }

    @NotNull
    public final AgentCardHandler getAgentCardHandler() {
        return this.agentCardHandler;
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @ResponseBody
    @NotNull
    public final ResponseEntity<AgentCard> agentCard(@NotNull ServletRequest servletRequest) {
        Intrinsics.checkNotNullParameter((Object)servletRequest, (String)"servletRequest");
        String string = servletRequest.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScheme(...)");
        String string2 = servletRequest.getServerName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getServerName(...)");
        AgentCard agentCard = this.agentCardHandler.agentCard(string, string2, servletRequest.getServerPort());
        ResponseEntity responseEntity = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)agentCard);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResponseBody
    @NotNull
    public final Object handleJsonRpc(@RequestBody @NotNull Map<String, ? extends Object> requestMap) {
        Intrinsics.checkNotNullParameter(requestMap, (String)"requestMap");
        try {
            SseEmitter sseEmitter;
            String method;
            this.logger.debug("Received JSON-RPC request: {}", requestMap);
            Object object = requestMap.get("method");
            String string = method = object instanceof String ? (String)object : null;
            if (Intrinsics.areEqual((Object)method, (Object)"message/stream")) {
                SendStreamingMessageRequest request2 = (SendStreamingMessageRequest)this.objectMapper.convertValue(requestMap, SendStreamingMessageRequest.class);
                Intrinsics.checkNotNull((Object)request2);
                sseEmitter = this.agentCardHandler.handleJsonRpcStream((StreamingJSONRPCRequest)request2);
                return sseEmitter;
            }
            String string2 = method;
            if (string2 == null) throw new UnsupportedOperationException("Method " + method + " is not supported");
            int n = -1;
            switch (string2.hashCode()) {
                case -1330443120: {
                    if (string2.equals("message/send")) {
                        n = 1;
                    }
                    break;
                }
                case 197325141: {
                    if (string2.equals("tasks/get")) {
                        n = 2;
                    }
                    break;
                }
                case -1415243749: {
                    if (string2.equals("tasks/cancel")) {
                        n = 3;
                    }
                    break;
                }
            }
            NonStreamingJSONRPCRequest request = switch (n) {
                case 1 -> (NonStreamingJSONRPCRequest)this.objectMapper.convertValue(requestMap, SendMessageRequest.class);
                case 2 -> (NonStreamingJSONRPCRequest)this.objectMapper.convertValue(requestMap, GetTaskRequest.class);
                case 3 -> (NonStreamingJSONRPCRequest)this.objectMapper.convertValue(requestMap, CancelTaskRequest.class);
                default -> throw new UnsupportedOperationException("Method " + method + " is not supported");
            };
            ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON);
            Intrinsics.checkNotNull((Object)request);
            ResponseEntity request2 = bodyBuilder.body(this.agentCardHandler.handleJsonRpc(request));
            Intrinsics.checkNotNull((Object)request2);
            sseEmitter = request2;
            return sseEmitter;
        }
        catch (Exception e) {
            Object requestId = requestMap.get("id");
            ResponseEntity responseEntity = ResponseEntity.status((int)500).contentType(MediaType.APPLICATION_JSON).body((Object)new JSONRPCErrorResponse(requestId, new JSONRPCError(Integer.valueOf(500), "Internal server error: " + e.getMessage(), null)));
            Intrinsics.checkNotNull((Object)responseEntity);
            return responseEntity;
        }
    }
}

