/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.ollama;

import com.embabel.agent.config.models.ollama.OllamaNodeConfig;
import com.embabel.agent.config.models.ollama.OllamaNodeProperties;
import com.embabel.agent.config.models.ollama.OllamaOptionsConverter;
import com.embabel.common.ai.model.ConfigurableModelProviderProperties;
import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.ai.model.Llm;
import com.embabel.common.ai.model.OptionsConverter;
import com.embabel.common.ai.model.PricingModel;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micrometer.observation.ObservationRegistry;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.ollama.OllamaChatModel;
import org.springframework.ai.ollama.OllamaEmbeddingModel;
import org.springframework.ai.ollama.api.OllamaApi;
import org.springframework.ai.ollama.api.OllamaOptions;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001:\u0003+,-B9\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0012J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0012J\b\u0010\u0017\u001a\u00020\u0018H\u0017J$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0012J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0003H\u0012J$\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0012J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0003H\u0012J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0015H\u0012J\u001a\u0010\"\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0012J6\u0010#\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00140%H\u0012J\b\u0010&\u001a\u00020\u0018H\u0012J\b\u0010'\u001a\u00020\u0018H\u0012J\b\u0010(\u001a\u00020\u0018H\u0012J\u0018\u0010)\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006."}, d2={"Lcom/embabel/agent/config/models/ollama/OllamaModelsConfig;", "", "baseUrl", "", "nodeProperties", "Lcom/embabel/agent/config/models/ollama/OllamaNodeProperties;", "configurableBeanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "properties", "Lcom/embabel/common/ai/model/ConfigurableModelProviderProperties;", "observationRegistry", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/observation/ObservationRegistry;", "<init>", "(Ljava/lang/String;Lcom/embabel/agent/config/models/ollama/OllamaNodeProperties;Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;Lcom/embabel/common/ai/model/ConfigurableModelProviderProperties;Lorg/springframework/beans/factory/ObjectProvider;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "loadModelsFromUrl", "", "Lcom/embabel/agent/config/models/ollama/OllamaModelsConfig$Model;", "loadModels", "registerModels", "", "ollamaLlmOf", "Lcom/embabel/common/ai/model/Llm;", "modelName", "nodeName", "name", "ollamaEmbeddingServiceOf", "Lcom/embabel/common/ai/model/EmbeddingService;", "normalizeModelNameForBean", "model", "createUniqueModelName", "registerModelsFromUrl", "beanNameProvider", "Lkotlin/Function1;", "registerDefaultMode", "registerMultiNodeOnlyMode", "registerHybridMode", "registerNodeModels", "nodeBaseUrl", "ModelResponse", "ModelDetails", "Model", "embabel-agent-ollama-autoconfigure"})
@SourceDebugExtension(value={"SMAP\nOllamaModelsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OllamaModelsConfig.kt\ncom/embabel/agent/config/models/ollama/OllamaModelsConfig\n+ 2 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,296:1\n43#2:297\n1611#3,9:298\n1863#3:307\n1864#3:309\n1620#3:310\n1557#3:312\n1628#3,3:313\n1863#3:316\n1863#3,2:317\n1863#3,2:319\n1864#3:321\n1863#3,2:322\n1#4:308\n1#4:311\n*S KotlinDebug\n*F\n+ 1 OllamaModelsConfig.kt\ncom/embabel/agent/config/models/ollama/OllamaModelsConfig\n*L\n79#1:297\n81#1:298,9\n81#1:307\n81#1:309\n81#1:310\n221#1:312\n221#1:313,3\n224#1:316\n230#1:317,2\n243#1:319,2\n224#1:321\n268#1:322,2\n81#1:308\n*E\n"})
public class OllamaModelsConfig {
    @NotNull
    private final String baseUrl;
    @Nullable
    private final OllamaNodeProperties nodeProperties;
    @NotNull
    private final ConfigurableBeanFactory configurableBeanFactory;
    @NotNull
    private final ConfigurableModelProviderProperties properties;
    @NotNull
    private final ObjectProvider<ObservationRegistry> observationRegistry;
    private final Logger logger;

    public OllamaModelsConfig(@Value(value="${spring.ai.ollama.base-url}") @NotNull String baseUrl, @Nullable OllamaNodeProperties nodeProperties, @NotNull ConfigurableBeanFactory configurableBeanFactory, @NotNull ConfigurableModelProviderProperties properties, @NotNull ObjectProvider<ObservationRegistry> observationRegistry) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)configurableBeanFactory, (String)"configurableBeanFactory");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(observationRegistry, (String)"observationRegistry");
        this.baseUrl = baseUrl;
        this.nodeProperties = nodeProperties;
        this.configurableBeanFactory = configurableBeanFactory;
        this.properties = properties;
        this.observationRegistry = observationRegistry;
        this.logger = LoggerFactory.getLogger(OllamaModelsConfig.class);
    }

    /*
     * WARNING - void declaration
     */
    private List<Model> loadModelsFromUrl(String baseUrl) {
        List list;
        try {
            List list2;
            void $this$body$iv;
            RestClient restClient = RestClient.create();
            Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"create(...)");
            RestClient restClient2 = restClient;
            MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
            RestClient.ResponseSpec responseSpec = restClient2.get().uri(baseUrl + "/api/tags", new Object[0]).accept(mediaTypeArray).retrieve();
            Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
            RestClient.ResponseSpec responseSpec2 = responseSpec;
            boolean $i$f$body = false;
            ModelResponse response = (ModelResponse)$this$body$iv.body((ParameterizedTypeReference)new ParameterizedTypeReference<ModelResponse>(){});
            Object object = response;
            if (object != null && (object = ((ModelResponse)object).getModels()) != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = (Iterable)object;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Model model;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    ModelDetails modelDetails = (ModelDetails)element$iv$iv;
                    boolean bl2 = false;
                    if (!StringsKt.isBlank((CharSequence)modelDetails.getName())) {
                        String string = StringsKt.replace$default((String)modelDetails.getName(), (String)":", (String)"-", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                        model = new Model(string, modelDetails.getName(), modelDetails.getSize());
                    } else {
                        model = null;
                    }
                    if (model == null) continue;
                    Model it$iv$iv = model;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        catch (Exception e) {
            this.logger.warn("Failed to load models from {}: {}", (Object)baseUrl, (Object)e.getMessage());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private List<Model> loadModels() {
        return this.loadModelsFromUrl(this.baseUrl);
    }

    @PostConstruct
    public void registerModels() {
        Object object;
        Object object2 = this.nodeProperties;
        if (object2 != null && (object2 = ((OllamaNodeProperties)object2).getNodes()) != null) {
            Object object3;
            Object it = object3 = object2;
            boolean bl = false;
            object = !((Collection)it).isEmpty() ? object3 : null;
        } else {
            object = null;
        }
        Object nodes = object;
        boolean hasDefaultUrl = !StringsKt.isBlank((CharSequence)this.baseUrl);
        if (hasDefaultUrl && nodes == null) {
            this.logger.info("Using default Ollama instance at {}", (Object)this.baseUrl);
            this.registerDefaultMode();
        } else if (!hasDefaultUrl && nodes != null) {
            this.logger.info("Using {} Ollama nodes", (Object)nodes.size());
            this.registerMultiNodeOnlyMode();
        } else if (hasDefaultUrl && nodes != null) {
            this.logger.info("Using default instance + {} nodes", (Object)nodes.size());
            this.registerHybridMode();
        } else {
            this.logger.warn("No Ollama configuration found. Skipping model registration.");
        }
    }

    private Llm ollamaLlmOf(String modelName, String baseUrl, String nodeName) {
        String uniqueModelName = this.createUniqueModelName(modelName, nodeName);
        OllamaChatModel springChatModel = OllamaChatModel.builder().ollamaApi(OllamaApi.builder().baseUrl(baseUrl).restClientBuilder(RestClient.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(OllamaModelsConfig::ollamaLlmOf$lambda$2))).webClientBuilder(WebClient.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(OllamaModelsConfig::ollamaLlmOf$lambda$3))).build()).defaultOptions(OllamaOptions.builder().model(modelName).build()).observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(OllamaModelsConfig::ollamaLlmOf$lambda$4)).toolCallingManager((ToolCallingManager)ToolCallingManager.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(OllamaModelsConfig::ollamaLlmOf$lambda$5)).build()).build();
        Intrinsics.checkNotNull((Object)springChatModel);
        OllamaChatModel ollamaChatModel = springChatModel;
        PricingModel pricingModel = PricingModel.Companion.getALL_YOU_CAN_EAT();
        OllamaOptionsConverter ollamaOptionsConverter = OllamaOptionsConverter.INSTANCE;
        return new Llm(uniqueModelName, "Ollama", (ChatModel)ollamaChatModel, (OptionsConverter)ollamaOptionsConverter, null, null, pricingModel, 48, null);
    }

    static /* synthetic */ Llm ollamaLlmOf$default(OllamaModelsConfig ollamaModelsConfig, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ollamaLlmOf");
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return ollamaModelsConfig.ollamaLlmOf(string, string2, string3);
    }

    private Llm ollamaLlmOf(String name) {
        return OllamaModelsConfig.ollamaLlmOf$default(this, name, this.baseUrl, null, 4, null);
    }

    private EmbeddingService ollamaEmbeddingServiceOf(String modelName, String baseUrl, String nodeName) {
        String uniqueModelName = this.createUniqueModelName(modelName, nodeName);
        OllamaEmbeddingModel springEmbeddingModel = OllamaEmbeddingModel.builder().ollamaApi(OllamaApi.builder().baseUrl(baseUrl).restClientBuilder(RestClient.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(OllamaModelsConfig::ollamaEmbeddingServiceOf$lambda$6))).webClientBuilder(WebClient.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(OllamaModelsConfig::ollamaEmbeddingServiceOf$lambda$7))).build()).defaultOptions(OllamaOptions.builder().model(modelName).build()).build();
        Intrinsics.checkNotNull((Object)springEmbeddingModel);
        OllamaEmbeddingModel ollamaEmbeddingModel = springEmbeddingModel;
        return new EmbeddingService(uniqueModelName, "Ollama", (EmbeddingModel)ollamaEmbeddingModel);
    }

    static /* synthetic */ EmbeddingService ollamaEmbeddingServiceOf$default(OllamaModelsConfig ollamaModelsConfig, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ollamaEmbeddingServiceOf");
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return ollamaModelsConfig.ollamaEmbeddingServiceOf(string, string2, string3);
    }

    private EmbeddingService ollamaEmbeddingServiceOf(String name) {
        return OllamaModelsConfig.ollamaEmbeddingServiceOf$default(this, name, this.baseUrl, null, 4, null);
    }

    private String normalizeModelNameForBean(Model model) {
        String string = StringsKt.replace$default((String)model.getModel(), (String)":", (String)"-", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    private String createUniqueModelName(String modelName, String nodeName) {
        Object object;
        block3: {
            block2: {
                object = nodeName;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = it + "-" + modelName;
                object = string;
                if (string != null) break block3;
            }
            object = modelName;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private void registerModelsFromUrl(String baseUrl, String nodeName, Function1<? super Model, ? extends List<String>> beanNameProvider) {
        Object contextName;
        List<Model> models = this.loadModelsFromUrl(baseUrl);
        String string = nodeName;
        Object object = contextName = string == null ? "default instance" : "node '" + string + "'";
        if (models.isEmpty()) {
            this.logger.warn("No Ollama models discovered from {} at {}. Check server configuration.", contextName, (Object)baseUrl);
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object[] objectArray = new Object[3];
            objectArray[0] = models.size();
            objectArray[1] = contextName;
            Iterable iterable = models;
            int n = 2;
            Object[] objectArray2 = objectArray;
            String string2 = "Discovered {} Ollama models from {}: {}";
            Logger logger = this.logger;
            boolean $i$f$map = false;
            void var9_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Model model = (Model)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = collection;
            logger.info(string2, objectArray);
        }
        Iterable $this$forEach$iv = models;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Model model = (Model)element$iv;
            boolean bl = false;
            try {
                String beanName;
                boolean $i$f$forEach2;
                Iterable $this$forEach$iv2;
                if (this.properties.allWellKnownEmbeddingServiceNames().contains(model.getModel())) {
                    EmbeddingService embeddingService = this.ollamaEmbeddingServiceOf(model.getModel(), baseUrl, nodeName);
                    $this$forEach$iv2 = (Iterable)beanNameProvider.invoke((Object)model);
                    $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        beanName = (String)element$iv2;
                        boolean bl2 = false;
                        String embeddingBeanName = StringsKt.replace$default((String)beanName, (String)"ollamaModel-", (String)"ollamaEmbeddingModel-", (boolean)false, (int)4, null);
                        this.configurableBeanFactory.registerSingleton(embeddingBeanName, (Object)embeddingService);
                        this.logger.debug("Successfully registered Ollama embedding service {} as bean {}", (Object)model.getName(), (Object)embeddingBeanName);
                    }
                    continue;
                }
                Llm llm = this.ollamaLlmOf(model.getModel(), baseUrl, nodeName);
                $this$forEach$iv2 = (Iterable)beanNameProvider.invoke((Object)model);
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    beanName = (String)element$iv2;
                    boolean bl3 = false;
                    this.configurableBeanFactory.registerSingleton(beanName, (Object)llm);
                    this.logger.debug("Successfully registered Ollama LLM {} as bean {}", (Object)model.getName(), (Object)beanName);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to register Ollama model {}: {}", (Object)model.getName(), (Object)e.getMessage());
            }
        }
    }

    static /* synthetic */ void registerModelsFromUrl$default(OllamaModelsConfig ollamaModelsConfig, String string, String string2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerModelsFromUrl");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        ollamaModelsConfig.registerModelsFromUrl(string, string2, (Function1<? super Model, ? extends List<String>>)function1);
    }

    private void registerDefaultMode() {
        this.registerModelsFromUrl(this.baseUrl, null, (Function1<? super Model, ? extends List<String>>)((Function1)arg_0 -> OllamaModelsConfig.registerDefaultMode$lambda$13(this, arg_0)));
    }

    private void registerMultiNodeOnlyMode() {
        block1: {
            Object object = this.nodeProperties;
            if (object == null || (object = ((OllamaNodeProperties)object).getNodes()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OllamaNodeConfig node = (OllamaNodeConfig)element$iv;
                boolean bl = false;
                this.registerNodeModels(node.getName(), node.getBaseUrl());
            }
        }
    }

    private void registerHybridMode() {
        this.registerDefaultMode();
        this.registerMultiNodeOnlyMode();
    }

    private void registerNodeModels(String nodeName, String nodeBaseUrl) {
        this.registerModelsFromUrl(nodeBaseUrl, nodeName, (Function1<? super Model, ? extends List<String>>)((Function1)arg_0 -> OllamaModelsConfig.registerNodeModels$lambda$15(this, nodeName, arg_0)));
    }

    private static final ObservationRegistry ollamaLlmOf$lambda$2() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry ollamaLlmOf$lambda$3() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry ollamaLlmOf$lambda$4() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry ollamaLlmOf$lambda$5() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry ollamaEmbeddingServiceOf$lambda$6() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry ollamaEmbeddingServiceOf$lambda$7() {
        return ObservationRegistry.NOOP;
    }

    private static final List registerDefaultMode$lambda$13(OllamaModelsConfig this$0, Model model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        String normalizedName = this$0.normalizeModelNameForBean(model);
        return CollectionsKt.listOf((Object)("ollamaModel-" + normalizedName));
    }

    private static final List registerNodeModels$lambda$15(OllamaModelsConfig this$0, String $nodeName, Model model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        String normalizedName = this$0.normalizeModelNameForBean(model);
        return CollectionsKt.listOf((Object)("ollamaModel-" + $nodeName + "-" + normalizedName));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/embabel/agent/config/models/ollama/OllamaModelsConfig$Model;", "", "name", "", "model", "size", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;J)V", "getName", "()Ljava/lang/String;", "getModel", "getSize", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "embabel-agent-ollama-autoconfigure"})
    private static final class Model {
        @NotNull
        private final String name;
        @NotNull
        private final String model;
        private final long size;

        public Model(@NotNull String name, @NotNull String model, long size) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this.name = name;
            this.model = model;
            this.size = size;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getModel() {
            return this.model;
        }

        public final long getSize() {
            return this.size;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.model;
        }

        public final long component3() {
            return this.size;
        }

        @NotNull
        public final Model copy(@NotNull String name, @NotNull String model, long size) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return new Model(name, model, size);
        }

        public static /* synthetic */ Model copy$default(Model model, String string, String string2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = model.name;
            }
            if ((n & 2) != 0) {
                string2 = model.model;
            }
            if ((n & 4) != 0) {
                l = model.size;
            }
            return model.copy(string, string2, l);
        }

        @NotNull
        public String toString() {
            return "Model(name=" + this.name + ", model=" + this.model + ", size=" + this.size + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.model.hashCode();
            result = result * 31 + Long.hashCode(this.size);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Model)) {
                return false;
            }
            Model model = (Model)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)model.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.model, (Object)model.model)) {
                return false;
            }
            return this.size == model.size;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0003\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/embabel/agent/config/models/ollama/OllamaModelsConfig$ModelDetails;", "", "name", "", "size", "", "modifiedAt", "<init>", "(Ljava/lang/String;JLjava/lang/String;)V", "getName", "()Ljava/lang/String;", "getSize", "()J", "getModifiedAt", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "embabel-agent-ollama-autoconfigure"})
    private static final class ModelDetails {
        @NotNull
        private final String name;
        private final long size;
        @NotNull
        private final String modifiedAt;

        public ModelDetails(@JsonProperty(value="name") @NotNull String name, @JsonProperty(value="size") long size, @JsonProperty(value="modified_at") @NotNull String modifiedAt) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)modifiedAt, (String)"modifiedAt");
            this.name = name;
            this.size = size;
            this.modifiedAt = modifiedAt;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getSize() {
            return this.size;
        }

        @NotNull
        public final String getModifiedAt() {
            return this.modifiedAt;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final long component2() {
            return this.size;
        }

        @NotNull
        public final String component3() {
            return this.modifiedAt;
        }

        @NotNull
        public final ModelDetails copy(@JsonProperty(value="name") @NotNull String name, @JsonProperty(value="size") long size, @JsonProperty(value="modified_at") @NotNull String modifiedAt) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)modifiedAt, (String)"modifiedAt");
            return new ModelDetails(name, size, modifiedAt);
        }

        public static /* synthetic */ ModelDetails copy$default(ModelDetails modelDetails, String string, long l, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = modelDetails.name;
            }
            if ((n & 2) != 0) {
                l = modelDetails.size;
            }
            if ((n & 4) != 0) {
                string2 = modelDetails.modifiedAt;
            }
            return modelDetails.copy(string, l, string2);
        }

        @NotNull
        public String toString() {
            return "ModelDetails(name=" + this.name + ", size=" + this.size + ", modifiedAt=" + this.modifiedAt + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Long.hashCode(this.size);
            result = result * 31 + this.modifiedAt.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModelDetails)) {
                return false;
            }
            ModelDetails modelDetails = (ModelDetails)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)modelDetails.name)) {
                return false;
            }
            if (this.size != modelDetails.size) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.modifiedAt, (Object)modelDetails.modifiedAt);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/embabel/agent/config/models/ollama/OllamaModelsConfig$ModelResponse;", "", "models", "", "Lcom/embabel/agent/config/models/ollama/OllamaModelsConfig$ModelDetails;", "<init>", "(Ljava/util/List;)V", "getModels", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "embabel-agent-ollama-autoconfigure"})
    private static final class ModelResponse {
        @NotNull
        private final List<ModelDetails> models;

        public ModelResponse(@JsonProperty(value="models") @NotNull List<ModelDetails> models) {
            Intrinsics.checkNotNullParameter(models, (String)"models");
            this.models = models;
        }

        @NotNull
        public final List<ModelDetails> getModels() {
            return this.models;
        }

        @NotNull
        public final List<ModelDetails> component1() {
            return this.models;
        }

        @NotNull
        public final ModelResponse copy(@JsonProperty(value="models") @NotNull List<ModelDetails> models) {
            Intrinsics.checkNotNullParameter(models, (String)"models");
            return new ModelResponse(models);
        }

        public static /* synthetic */ ModelResponse copy$default(ModelResponse modelResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = modelResponse.models;
            }
            return modelResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "ModelResponse(models=" + this.models + ")";
        }

        public int hashCode() {
            return ((Object)this.models).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModelResponse)) {
                return false;
            }
            ModelResponse modelResponse = (ModelResponse)other;
            return Intrinsics.areEqual(this.models, modelResponse.models);
        }
    }
}

