/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.ai.autoconfig;

import com.embabel.common.ai.autoconfig.LlmAutoConfigMetadata;
import com.embabel.common.ai.autoconfig.LlmAutoConfigMetadataLoader;
import com.embabel.common.ai.autoconfig.LlmAutoConfigProvider;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0019\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H$J\r\u0010\u0019\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u001a\u001a\u00020\u0007H$J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\n \f*\u0004\u0018\u00010\u00110\u0011X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/embabel/common/ai/autoconfig/AbstractYamlModelLoader;", "T", "Lcom/embabel/common/ai/autoconfig/LlmAutoConfigProvider;", "Lcom/embabel/common/ai/autoconfig/LlmAutoConfigMetadataLoader;", "resourceLoader", "Lorg/springframework/core/io/ResourceLoader;", "configPath", "", "<init>", "(Lorg/springframework/core/io/ResourceLoader;Ljava/lang/String;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "Lorg/slf4j/Logger;", "yamlMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getYamlMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "loadAutoConfigMetadata", "()Lcom/embabel/common/ai/autoconfig/LlmAutoConfigProvider;", "getProviderClass", "Lkotlin/reflect/KClass;", "createEmptyProvider", "getProviderName", "validateModels", "", "provider", "(Lcom/embabel/common/ai/autoconfig/LlmAutoConfigProvider;)V", "validateCommonFields", "model", "Lcom/embabel/common/ai/autoconfig/LlmAutoConfigMetadata;", "embabel-common-ai"})
@SourceDebugExtension(value={"SMAP\nAbstractModelLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractModelLoader.kt\ncom/embabel/common/ai/autoconfig/AbstractYamlModelLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public abstract class AbstractYamlModelLoader<T extends LlmAutoConfigProvider<?>>
implements LlmAutoConfigMetadataLoader<T> {
    @NotNull
    private final ResourceLoader resourceLoader;
    @NotNull
    private final String configPath;
    private final Logger logger;
    private final ObjectMapper yamlMapper;

    public AbstractYamlModelLoader(@NotNull ResourceLoader resourceLoader, @NotNull String configPath) {
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        this.resourceLoader = resourceLoader;
        this.configPath = configPath;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.yamlMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper((JsonFactory)new YAMLFactory())).findAndRegisterModules().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
    }

    public /* synthetic */ AbstractYamlModelLoader(ResourceLoader resourceLoader, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            resourceLoader = (ResourceLoader)new DefaultResourceLoader();
        }
        this(resourceLoader, string);
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    protected final ObjectMapper getYamlMapper() {
        return this.yamlMapper;
    }

    @Override
    @NotNull
    public T loadAutoConfigMetadata() {
        T t;
        try {
            T definitions;
            Object object;
            Object it;
            Object object2;
            Resource configResource = this.resourceLoader.getResource(this.configPath);
            if (configResource.exists()) {
                this.logger.info("Loading {} models from {}", (Object)this.getProviderName(), (Object)this.configPath);
                object2 = this.yamlMapper.readValue(configResource.getInputStream(), JvmClassMappingKt.getJavaClass(this.getProviderClass()));
                it = (LlmAutoConfigProvider)object2;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                this.validateModels(it);
                object = (LlmAutoConfigProvider)object2;
            } else {
                this.logger.warn("Configuration file {} not found, using empty model list", (Object)this.configPath);
                object = this.createEmptyProvider();
            }
            it = object2 = (definitions = object);
            boolean bl = false;
            this.logger.info("Loaded {} {} model definitions", (Object)it.getModels().size(), (Object)this.getProviderName());
            t = object2;
            Intrinsics.checkNotNull(t);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{this.getProviderName(), this.configPath, e};
            this.logger.error("Failed to load {} models from {}", objectArray);
            t = this.createEmptyProvider();
        }
        return t;
    }

    @NotNull
    protected abstract KClass<T> getProviderClass();

    @NotNull
    protected abstract T createEmptyProvider();

    @NotNull
    protected abstract String getProviderName();

    protected abstract void validateModels(@NotNull T var1);

    protected final void validateCommonFields(@NotNull LlmAutoConfigMetadata model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (!(!StringsKt.isBlank((CharSequence)model.getName()))) {
            boolean $i$a$-require-AbstractYamlModelLoader$validateCommonFields$32 = false;
            String $i$a$-require-AbstractYamlModelLoader$validateCommonFields$32 = "Model name cannot be blank";
            throw new IllegalArgumentException($i$a$-require-AbstractYamlModelLoader$validateCommonFields$32.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)model.getModelId()))) {
            boolean bl = false;
            String string = "Model ID cannot be blank";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

