/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.util;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\u001c\u0010\u0000\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u001a4\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00022\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"findAllSupertypes", "", "Ljava/lang/Class;", "clazz", "findImplementationsOnClasspath", "", "T", "interfaceClass", "basePackage", "", "embabel-common-util"})
@SourceDebugExtension(value={"SMAP\nreflectionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 reflectionUtils.kt\ncom/embabel/common/util/ReflectionUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class ReflectionUtilsKt {
    @NotNull
    public static final Set<Class<?>> findAllSupertypes(@NotNull Class<?> clazz) {
        Set supertypes;
        block0: {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            supertypes = new LinkedHashSet();
            Collection collection = supertypes;
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
            CollectionsKt.addAll((Collection)collection, (Object[])classArray);
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 == null) break block0;
            Class<?> superclass = clazz2;
            boolean bl = false;
            ((Collection)supertypes).add(clazz);
            CollectionsKt.addAll((Collection)supertypes, (Iterable)ReflectionUtilsKt.findAllSupertypes(superclass));
        }
        return CollectionsKt.toSet((Iterable)supertypes);
    }

    @NotNull
    public static final <T> List<Class<? extends T>> findImplementationsOnClasspath(@NotNull Class<T> interfaceClass, @Nullable String basePackage) {
        Intrinsics.checkNotNullParameter(interfaceClass, (String)"interfaceClass");
        if (!interfaceClass.isInterface()) {
            boolean $i$a$-require-ReflectionUtilsKt$findImplementationsOnClasspath$22 = false;
            String $i$a$-require-ReflectionUtilsKt$findImplementationsOnClasspath$22 = interfaceClass.getSimpleName() + " is not an interface";
            throw new IllegalArgumentException($i$a$-require-ReflectionUtilsKt$findImplementationsOnClasspath$22.toString());
        }
        Logger logger = LoggerFactory.getLogger((String)"com.embabel.common.util.reflectionUtils");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
        List implementations = new ArrayList();
        Object object = basePackage;
        if (object == null) {
            boolean bl = false;
            String string = interfaceClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String[] stringArray = new String[]{"."};
            List packageParts = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            object = packageParts.size() >= 2 ? packageParts.get(0) + "." + packageParts.get(1) : CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)packageParts, (int)1), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        }
        String packageToScan = object;
        logger.info("Looking under package [{}] for interface {}", (Object)packageToScan, (Object)interfaceClass.getName());
        String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packageToScan) + "/**/*.class";
        try {
            Resource[] resourceArray = resolver.getResources(packageSearchPath);
            Intrinsics.checkNotNullExpressionValue((Object)resourceArray, (String)"getResources(...)");
            for (Resource resource : resourceArray) {
                String className;
                MetadataReader metadataReader;
                if (!resource.isReadable()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)metadataReaderFactory.getMetadataReader(resource), (String)"getMetadataReader(...)");
                Intrinsics.checkNotNullExpressionValue((Object)metadataReader.getClassMetadata().getClassName(), (String)"getClassName(...)");
                try {
                    Class<?> candidateClass = Class.forName(className);
                    if (candidateClass.isInterface() || Modifier.isAbstract(candidateClass.getModifiers()) || !interfaceClass.isAssignableFrom(candidateClass)) continue;
                    Intrinsics.checkNotNull(candidateClass, (String)"null cannot be cast to non-null type java.lang.Class<out T of com.embabel.common.util.ReflectionUtilsKt.findImplementationsOnClasspath>");
                    implementations.add(candidateClass);
                }
                catch (Exception e) {
                    System.out.println((Object)("Failed to load class: " + className + ", reason: " + e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            System.out.println((Object)("Error scanning classpath: " + e.getMessage()));
        }
        return implementations;
    }

    public static /* synthetic */ List findImplementationsOnClasspath$default(Class clazz, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return ReflectionUtilsKt.findImplementationsOnClasspath(clazz, string);
    }
}

