/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql;

import com.google.common.collect.Maps;
import com.oembedler.moon.graphql.engine.GraphQLSchemaHolder;
import graphql.Assert;
import java.util.Map;

public class GraphQLSchemaLocator {
    private final Map<String, GraphQLSchemaHolder> graphQLSchemaHolders = Maps.newHashMap();
    private final int totalNumberOfSchemas;

    public GraphQLSchemaLocator(Map<String, GraphQLSchemaHolder> graphQLSchemaHolders) {
        this.graphQLSchemaHolders.putAll(graphQLSchemaHolders);
        this.totalNumberOfSchemas = this.graphQLSchemaHolders.size();
    }

    public GraphQLSchemaHolder getGraphQLSchemaHolder(String schemaName) {
        Assert.assertNotNull((Object)schemaName, (String)"Schema name can not be null");
        return this.containsSchema(schemaName) ? this.graphQLSchemaHolders.get(schemaName) : this.getSingleSchema();
    }

    public GraphQLSchemaHolder getSingleSchema() {
        return this.getTotalNumberOfSchemas() == 1 ? this.graphQLSchemaHolders.get(this.graphQLSchemaHolders.keySet().iterator().next()) : null;
    }

    public int getTotalNumberOfSchemas() {
        return this.totalNumberOfSchemas;
    }

    public boolean containsSchema(String schemaName) {
        Assert.assertNotNull((Object)schemaName, (String)"Schema name can not be null");
        return this.graphQLSchemaHolders.containsKey(schemaName);
    }
}

