/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oembedler.moon.graphql.engine.GraphQLSchemaHolder;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.SchemaUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class GraphQLQueryTemplate {
    private static final String MUTATION_TEMPLATE = "mutation %sQuery($%s: %s!) {   %s(%s: $%s) %s }";
    private final SchemaUtil schemaUtil = new SchemaUtil();
    private final GraphQLSchema graphQLSchema;
    private final GraphQLSchemaHolder graphQLSchemaHolder;
    private final ObjectMapper objectMapper;

    public GraphQLQueryTemplate(GraphQLSchemaHolder graphQLSchemaHolder) {
        Assert.notNull((Object)graphQLSchemaHolder, (String)"GraphQL Schema holder can not be null");
        this.graphQLSchemaHolder = graphQLSchemaHolder;
        this.graphQLSchema = this.graphQLSchemaHolder.getGraphQLSchema();
        this.objectMapper = new ObjectMapper();
        if (!graphQLSchemaHolder.getGraphQLSchemaConfig().isDateAsTimestamp()) {
            this.objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(graphQLSchemaHolder.getGraphQLSchemaConfig().getDateFormat()));
        }
    }

    public MutationQuery forMutation(String mutationName, Object ... inputs) {
        return new MutationQuery(this.buildQuery(mutationName), this.buildInput(mutationName, inputs));
    }

    public String buildQuery(String mutationName) {
        Assert.hasText((String)mutationName, (String)"Mutation value must not be null");
        GraphQLObjectType objectType = this.graphQLSchema.getMutationType();
        GraphQLFieldDefinition graphQLFieldDefinition = objectType.getFieldDefinition(mutationName);
        Assert.notNull((Object)graphQLFieldDefinition, (String)"Mutation does not exist");
        GraphQLObjectType graphQLOutputType = (GraphQLObjectType)graphQLFieldDefinition.getType();
        return String.format(MUTATION_TEMPLATE, mutationName, this.getMutationArgumentName(graphQLFieldDefinition), this.getMutationArgumentType(graphQLFieldDefinition), mutationName, this.getMutationInputArgumentName(), this.getMutationInputArgumentName(), this.expandNestedObjectTree("", graphQLOutputType));
    }

    private String getMutationInputArgumentName() {
        return this.graphQLSchemaHolder.getGraphQLSchemaConfig().getMutationInputArgumentName();
    }

    protected GraphQLArgument getMutationArgument(GraphQLFieldDefinition mutationGraphQLFieldDefinition) {
        List graphQLArguments = mutationGraphQLFieldDefinition.getArguments();
        return graphQLArguments.size() > 0 ? (GraphQLArgument)graphQLArguments.get(0) : null;
    }

    protected String getMutationArgumentName(GraphQLFieldDefinition mutationGraphQLFieldDefinition) {
        GraphQLArgument graphQLArgument = this.getMutationArgument(mutationGraphQLFieldDefinition);
        return graphQLArgument != null ? graphQLArgument.getName() : "";
    }

    protected String getMutationArgumentType(GraphQLFieldDefinition mutationGraphQLFieldDefinition) {
        GraphQLArgument graphQLArgument = this.getMutationArgument(mutationGraphQLFieldDefinition);
        GraphQLInputType graphQLInputType = graphQLArgument.getType();
        return graphQLInputType != null ? this.schemaUtil.getUnmodifiedType((GraphQLType)graphQLInputType).getName() : "";
    }

    protected String expandNestedObjectTree(String nodeName, GraphQLObjectType graphQLOutputType) {
        StringBuilder stringBuilder = new StringBuilder();
        for (GraphQLFieldDefinition graphQLFieldDefinition : graphQLOutputType.getFieldDefinitions()) {
            GraphQLUnmodifiedType graphQLUnmodifiedType = this.schemaUtil.getUnmodifiedType((GraphQLType)graphQLFieldDefinition.getType());
            if (graphQLUnmodifiedType instanceof GraphQLScalarType) {
                stringBuilder.append(graphQLFieldDefinition.getName() + ", ");
                continue;
            }
            GraphQLObjectType castedGraphQLObjectType = (GraphQLObjectType)graphQLUnmodifiedType;
            stringBuilder.append(this.expandNestedObjectTree(graphQLFieldDefinition.getName(), castedGraphQLObjectType));
        }
        String result = StringUtils.removeEnd((String)stringBuilder.toString(), (String)", ");
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result}) ? String.format("%s { %s }", nodeName, result) : "";
    }

    protected Map<String, Object> buildInput(String mutationName, Object ... inputs) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        GraphQLObjectType objectType = this.graphQLSchema.getMutationType();
        GraphQLFieldDefinition graphQLFieldDefinition = objectType.getFieldDefinition(mutationName);
        List graphQLArguments = graphQLFieldDefinition.getArguments();
        HashMap<String, Object> inputArgs = new HashMap<String, Object>();
        if (inputs != null && inputs.length > 0) {
            Map<Class<?>, GraphQLInputObjectField> argsDefs = this.graphQLSchemaHolder.getMutationInputTypeResolverMap().get(mutationName);
            for (Object object : inputs) {
                Class<?> cls = object.getClass();
                GraphQLInputObjectField graphQLInputObjectField = argsDefs.get(cls);
                if (graphQLInputObjectField == null) continue;
                inputArgs.put(graphQLInputObjectField.getName(), this.convertToMap(object));
            }
        }
        if (this.isClientMutationIdInjected()) {
            inputArgs.put(this.getClientMutationIdName(), this.generateClientMutationId());
        }
        variables.put(this.getMutationInputArgumentName(), inputArgs);
        return variables;
    }

    private Object convertToMap(Object argObject) {
        return this.objectMapper.convertValue(argObject, Object.class);
    }

    private boolean isClientMutationIdInjected() {
        return this.graphQLSchemaHolder.getGraphQLSchemaConfig().isInjectClientMutationId();
    }

    private String getClientMutationIdName() {
        return this.graphQLSchemaHolder.getGraphQLSchemaConfig().getClientMutationIdName();
    }

    private String generateClientMutationId() {
        return UUID.randomUUID().toString();
    }

    public static final class MutationQuery {
        private final String query;
        private final Map<String, Object> variables;

        public MutationQuery(String query, Map<String, Object> variables) {
            this.query = query;
            this.variables = variables;
        }

        public String getQuery() {
            return this.query;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }
    }
}

