/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine;

import com.oembedler.moon.graphql.GraphQLSchemaBeanFactory;
import com.oembedler.moon.graphql.engine.GraphQLSchemaConfig;
import com.oembedler.moon.graphql.engine.GraphQLSchemaHolder;
import com.oembedler.moon.graphql.engine.dfs.GraphQLSchemaDfsTraversal;
import graphql.schema.GraphQLSchema;
import org.springframework.util.Assert;

public class GraphQLSchemaBuilder {
    private final GraphQLSchemaConfig graphQLSchemaConfig;
    private final GraphQLSchemaBeanFactory graphQLSchemaBeanFactory;

    public GraphQLSchemaBuilder(GraphQLSchemaConfig graphQLSchemaConfig, GraphQLSchemaBeanFactory graphQLSchemaBeanFactory) {
        Assert.notNull((Object)graphQLSchemaConfig, (String)"Schema configuration can not be null");
        Assert.notNull((Object)graphQLSchemaBeanFactory, (String)"Schema bean factory can not be null");
        this.graphQLSchemaConfig = graphQLSchemaConfig;
        this.graphQLSchemaBeanFactory = graphQLSchemaBeanFactory;
    }

    public GraphQLSchemaHolder buildSchema(Class<?> schemaClass) {
        Assert.notNull(schemaClass, (String)"Schema class can not be null");
        GraphQLSchemaDfsTraversal graphQLSchemaDfsTraversal = new GraphQLSchemaDfsTraversal(schemaClass, this.getGraphQLSchemaConfig(), this.getGraphQLSchemaBeanFactory());
        GraphQLSchema graphQLSchema = graphQLSchemaDfsTraversal.traverse();
        GraphQLSchemaHolder graphQLSchemaHolder = new GraphQLSchemaHolder(graphQLSchemaDfsTraversal.getSchemaName(), graphQLSchema, this.getGraphQLSchemaConfig(), graphQLSchemaDfsTraversal.getObjectTypeResolverMap());
        graphQLSchemaHolder.setMutationInputTypeResolverMap(graphQLSchemaDfsTraversal.getMutationInputTypeResolverMap());
        graphQLSchemaHolder.setMutationReturnTypeResolverMap(graphQLSchemaDfsTraversal.getMutationReturnTypeResolverMap());
        graphQLSchemaHolder.setFieldDefinitionResolverMap(graphQLSchemaDfsTraversal.getFieldDefinitionResolverMap());
        return graphQLSchemaHolder;
    }

    public GraphQLSchemaConfig getGraphQLSchemaConfig() {
        return this.graphQLSchemaConfig;
    }

    public GraphQLSchemaBeanFactory getGraphQLSchemaBeanFactory() {
        return this.graphQLSchemaBeanFactory;
    }
}

