/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine;

import org.springframework.util.Assert;

public class GraphQLSchemaConfig {
    private String clientMutationIdName = "clientMutationId";
    private boolean injectClientMutationId = true;
    private boolean allowEmptyClientMutationId = false;
    private String mutationInputArgumentName = "input";
    private String outputObjectNamePrefix = "Payload";
    private String inputObjectNamePrefix = "Input";
    private String schemaMutationObjectName = "Mutation";
    private boolean dateAsTimestamp = true;
    private String dateFormat = "yyyy-MM-dd'T'HH:mm'Z'";

    public String getClientMutationIdName() {
        return this.clientMutationIdName;
    }

    public GraphQLSchemaConfig setClientMutationIdName(String clientMutationIdName) {
        Assert.hasText((String)clientMutationIdName, (String)"Client mutation identity value can not be null!");
        this.clientMutationIdName = clientMutationIdName;
        return this;
    }

    public boolean isInjectClientMutationId() {
        return this.injectClientMutationId;
    }

    public GraphQLSchemaConfig setInjectClientMutationId(boolean injectClientMutationId) {
        this.injectClientMutationId = injectClientMutationId;
        return this;
    }

    public boolean isAllowEmptyClientMutationId() {
        return this.allowEmptyClientMutationId;
    }

    public GraphQLSchemaConfig setAllowEmptyClientMutationId(boolean allowEmptyClientMutationId) {
        this.allowEmptyClientMutationId = allowEmptyClientMutationId;
        return this;
    }

    public String getMutationInputArgumentName() {
        return this.mutationInputArgumentName;
    }

    public GraphQLSchemaConfig setMutationInputArgumentName(String mutationInputArgumentName) {
        Assert.notNull((Object)mutationInputArgumentName, (String)"Mutation input argument value can not be null!");
        this.mutationInputArgumentName = mutationInputArgumentName;
        return this;
    }

    public String getOutputObjectNamePrefix() {
        return this.outputObjectNamePrefix;
    }

    public GraphQLSchemaConfig setOutputObjectNamePrefix(String outputObjectNamePrefix) {
        Assert.notNull((Object)outputObjectNamePrefix, (String)"Output object value can not be null!");
        this.outputObjectNamePrefix = outputObjectNamePrefix;
        return this;
    }

    public String getInputObjectNamePrefix() {
        return this.inputObjectNamePrefix;
    }

    public GraphQLSchemaConfig setInputObjectNamePrefix(String inputObjectNamePrefix) {
        Assert.notNull((Object)inputObjectNamePrefix, (String)"Input object value can not be null!");
        this.inputObjectNamePrefix = inputObjectNamePrefix;
        return this;
    }

    public String getSchemaMutationObjectName() {
        return this.schemaMutationObjectName;
    }

    public GraphQLSchemaConfig setSchemaMutationObjectName(String schemaMutationObjectName) {
        Assert.notNull((Object)schemaMutationObjectName, (String)"Schema mutation object value can not be null!");
        this.schemaMutationObjectName = schemaMutationObjectName;
        return this;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        Assert.notNull((Object)dateFormat, (String)"Date format string can not be null!");
        this.dateFormat = dateFormat;
    }

    public boolean isDateAsTimestamp() {
        return this.dateAsTimestamp;
    }

    public void setDateAsTimestamp(boolean dateAsTimestamp) {
        this.dateAsTimestamp = dateAsTimestamp;
    }
}

