/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine;

import com.oembedler.moon.graphql.engine.stereotype.GraphQLSchema;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class GraphQLSchemaDiscoverer {
    private static final Class<? extends Annotation> GRAPH_QL_SCHEMA_ANNOTATION = GraphQLSchema.class;

    public static Set<Class<?>> findSchemaClasses(String basePackage) throws ClassNotFoundException {
        HashSet initialEntitySet = new HashSet();
        if (StringUtils.hasText((String)basePackage)) {
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(GRAPH_QL_SCHEMA_ANNOTATION));
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                initialEntitySet.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)GraphQLSchemaDiscoverer.class.getClassLoader()));
            }
        }
        return initialEntitySet;
    }
}

