/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oembedler.moon.graphql.engine.dfs.GraphQLMethodParameters;
import java.lang.reflect.Method;
import java.util.Map;

public class MethodParametersBinder {
    private final ObjectMapper objectMapper;
    private final GraphQLMethodParameters graphQLMethodParameters;

    public MethodParametersBinder(Method targetMethod, Class<?> implClass) {
        this(new GraphQLMethodParameters(targetMethod, implClass));
    }

    public MethodParametersBinder(GraphQLMethodParameters graphQLMethodParameters) {
        this.graphQLMethodParameters = graphQLMethodParameters;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public Object[] bindParameters(Map<String, Object> parametersValues) {
        return this.bindAllParameters(parametersValues, null);
    }

    public Object[] bindParameters(Map<String, Object> parametersValues, Object[] bindByClassValues) {
        return this.bindAllParameters(parametersValues, bindByClassValues);
    }

    protected Object[] bindAllParameters(Map<String, Object> parametersValues, Object[] bindByClassValues) {
        if (this.getGraphQLMethodParameters().hasNoParameters()) {
            return null;
        }
        Object[] inputArgs = new Object[this.getGraphQLMethodParameters().getNumberOfParameters()];
        this.getGraphQLMethodParameters().getParameters().forEach(mpi -> {
            Class<?> parameterType;
            Object toMethodInputObject = null;
            Class<?> clazz = parameterType = mpi.isCollectionLike() ? mpi.getRawType() : mpi.getParameterType();
            if (mpi.isValidGraphQLInParameter()) {
                Object inputObject = parametersValues.get(mpi.getName());
                toMethodInputObject = this.getObjectMapper().convertValue(inputObject, parameterType);
            } else if (bindByClassValues != null) {
                for (Object value : bindByClassValues) {
                    if (value == null || !value.getClass().isAssignableFrom(parameterType)) continue;
                    toMethodInputObject = value;
                    break;
                }
            }
            objectArray2[mpi.getIdx()] = toMethodInputObject;
        });
        return inputArgs;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public GraphQLMethodParameters getGraphQLMethodParameters() {
        return this.graphQLMethodParameters;
    }
}

