/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine;

import com.oembedler.moon.graphql.engine.GraphQLSchemaConfig;
import com.oembedler.moon.graphql.engine.MethodParametersBinder;
import com.oembedler.moon.graphql.engine.ReflectionGraphQLDataMutator;
import com.oembedler.moon.graphql.engine.dfs.GraphQLMethodParameters;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedRuntimeException;

public class ReflectionGraphQLDataFetcher
implements DataFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionGraphQLDataMutator.class);
    private final Object targetObject;
    private final Method targetMethod;
    private final GraphQLSchemaConfig graphQLSchemaConfig;
    private final GraphQLMethodParameters graphQLMethodParameters;
    private final MethodParametersBinder methodParametersBinder;

    public ReflectionGraphQLDataFetcher(GraphQLSchemaConfig graphQLSchemaConfig, Object targetObject, Method targetMethod) {
        this.targetObject = targetObject;
        this.targetMethod = targetMethod;
        this.graphQLSchemaConfig = graphQLSchemaConfig;
        this.graphQLMethodParameters = new GraphQLMethodParameters(targetMethod, this.targetObject.getClass());
        this.methodParametersBinder = new MethodParametersBinder(this.graphQLMethodParameters);
    }

    public Object get(DataFetchingEnvironment environment) {
        Object targetMethodResult = null;
        try {
            this.beforeInvocation(environment);
            Object[] bindByClassValues = this.collectBindByClassValues(environment);
            Object[] inputArguments = this.getMethodParametersBinder().bindParameters(environment.getArguments(), bindByClassValues);
            if (ReflectionGraphQLDataFetcher.isAllNulls(inputArguments) && this.canApplySourceObject(environment)) {
                inputArguments = new Object[]{environment.getSource()};
            }
            targetMethodResult = this.getTargetMethod().invoke(this.getTargetObject(), inputArguments);
            targetMethodResult = this.afterInvocation(environment, targetMethodResult);
        }
        catch (Exception e) {
            String msg = "Exception while calling data fetcher [" + this.getTargetMethod().getName() + "]";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(msg, (Throwable)e);
            }
            throw new DataFetcherRuntimeException(msg, e);
        }
        return targetMethodResult;
    }

    public Object[] collectBindByClassValues(DataFetchingEnvironment environment) {
        Object[] bindByClassValues = new Object[]{environment, environment.getSource(), environment.getContext()};
        return bindByClassValues;
    }

    public static boolean isAllNulls(Object[] array) {
        if (array != null) {
            for (Object obj : array) {
                if (obj == null) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean canApplySourceObject(DataFetchingEnvironment environment) {
        return environment.getSource() != null && this.getGraphQLMethodParameters().getNumberOfParameters() > 0 ? this.getGraphQLMethodParameters().isCompatibleWith(0, environment.getSource().getClass()) : false;
    }

    protected void beforeInvocation(DataFetchingEnvironment environment) {
    }

    protected Object afterInvocation(DataFetchingEnvironment environment, Object targetMethodResult) {
        return targetMethodResult;
    }

    public GraphQLMethodParameters getGraphQLMethodParameters() {
        return this.graphQLMethodParameters;
    }

    public MethodParametersBinder getMethodParametersBinder() {
        return this.methodParametersBinder;
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public static final class DataFetcherRuntimeException
    extends NestedRuntimeException {
        public DataFetcherRuntimeException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

