/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine;

import com.oembedler.moon.graphql.engine.GraphQLSchemaConfig;
import com.oembedler.moon.graphql.engine.MethodParametersBinder;
import com.oembedler.moon.graphql.engine.dfs.GraphQLMethodParameters;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedRuntimeException;

public class ReflectionGraphQLDataMutator
implements DataFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionGraphQLDataMutator.class);
    private final Object targetObject;
    private final Method targetMethod;
    private final GraphQLSchemaConfig graphQLSchemaConfig;
    private final GraphQLMethodParameters graphQLMethodParameters;
    private final MethodParametersBinder methodParametersBinder;

    public ReflectionGraphQLDataMutator(GraphQLSchemaConfig graphQLSchemaConfig, Object targetObject, Method targetMethod) {
        this.targetObject = targetObject;
        this.targetMethod = targetMethod;
        this.graphQLSchemaConfig = graphQLSchemaConfig;
        this.graphQLMethodParameters = new GraphQLMethodParameters(targetMethod, this.targetObject.getClass());
        this.methodParametersBinder = new MethodParametersBinder(this.graphQLMethodParameters);
    }

    public Object get(DataFetchingEnvironment environment) {
        Object targetMethodResult = null;
        try {
            this.beforeInvocation(environment);
            Object[] bindByClassValues = this.collectBindByClassValues(environment);
            Object[] inputArguments = this.getMethodParametersBinder().bindParameters(this.unwrapInputArguments(environment), bindByClassValues);
            targetMethodResult = this.getTargetMethod().invoke(this.getTargetObject(), inputArguments);
            targetMethodResult = this.afterInvocation(environment, targetMethodResult);
        }
        catch (Exception e) {
            String msg = "Exception while calling data fetcher [" + this.getTargetMethod().getName() + "]";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(msg, (Throwable)e);
            }
            throw new DataMutatorRuntimeException(msg, e);
        }
        return targetMethodResult;
    }

    protected void beforeInvocation(DataFetchingEnvironment environment) {
    }

    protected Object afterInvocation(DataFetchingEnvironment environment, Object targetMethodResult) {
        Map<String, Object> inputMap = this.unwrapInputArguments(environment);
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        outputMap.put(this.getGraphQLMethodParameters().getReturnTypeName(), targetMethodResult);
        this.injectClientMutationIdIfRequired(inputMap, outputMap);
        return outputMap;
    }

    public Object[] collectBindByClassValues(DataFetchingEnvironment environment) {
        Object[] bindByClassValues = new Object[]{environment, environment.getSource(), environment.getContext()};
        return bindByClassValues;
    }

    protected Map<String, Object> unwrapInputArguments(DataFetchingEnvironment environment) {
        Map inputObject = null;
        String inArgName = this.getGraphQLSchemaConfig().getMutationInputArgumentName();
        if (environment.getArguments() != null && environment.getArguments() instanceof Map) {
            inputObject = (Map)environment.getArguments().get(inArgName);
        }
        return inputObject;
    }

    private void injectClientMutationIdIfRequired(Map<String, Object> inputMap, Map<String, Object> outputMap) {
        if (this.getGraphQLSchemaConfig().isInjectClientMutationId()) {
            String clientMutationId = (String)inputMap.get(this.getGraphQLSchemaConfig().getClientMutationIdName());
            outputMap.put(this.getGraphQLSchemaConfig().getClientMutationIdName(), clientMutationId);
        }
    }

    public GraphQLMethodParameters getGraphQLMethodParameters() {
        return this.graphQLMethodParameters;
    }

    public MethodParametersBinder getMethodParametersBinder() {
        return this.methodParametersBinder;
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public GraphQLSchemaConfig getGraphQLSchemaConfig() {
        return this.graphQLSchemaConfig;
    }

    public static final class DataMutatorRuntimeException
    extends NestedRuntimeException {
        public DataMutatorRuntimeException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

