/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine;

import com.oembedler.moon.graphql.engine.stereotype.GraphQLDescription;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLInterface;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLMutation;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLObject;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLSchema;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLUnion;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StereotypeUtils {
    public static String getGraphQLSchemaName(AnnotatedElement accessibleObject, String defaultValue) {
        return StereotypeUtils.getAnnotationValue(accessibleObject, GraphQLSchema.class, defaultValue);
    }

    public static String getGraphQLObjectName(AnnotatedElement accessibleObject, String defaultValue) {
        return StereotypeUtils.getAnnotationValue(accessibleObject, GraphQLObject.class, defaultValue);
    }

    public static String getGraphQLInterfaceName(AnnotatedElement accessibleObject, String defaultValue) {
        return StereotypeUtils.getAnnotationValue(accessibleObject, GraphQLInterface.class, defaultValue);
    }

    public static String getGraphQLUnionName(AnnotatedElement accessibleObject, String defaultValue) {
        return StereotypeUtils.getAnnotationValue(accessibleObject, GraphQLUnion.class, defaultValue);
    }

    public static String getGraphQLDescription(AnnotatedElement accessibleObject, String defaultValue) {
        return StereotypeUtils.getAnnotationValue(accessibleObject, GraphQLDescription.class, defaultValue);
    }

    public static String getGraphQLMutationName(AnnotatedElement accessibleObject, String defaultValue) {
        return StereotypeUtils.getAnnotationValue(accessibleObject, GraphQLMutation.class, defaultValue);
    }

    private static <T extends Annotation> String getAnnotationValue(AnnotatedElement accessibleObject, Class<T> annotationClass, String defaultValue) {
        Assert.noNullElements((Object[])new Object[]{accessibleObject, annotationClass, defaultValue}, (String)"input parameters must not be null");
        String result = defaultValue;
        T annotation = accessibleObject.getAnnotation(annotationClass);
        if (annotation != null && StringUtils.hasText((String)((String)AnnotationUtils.getValue(annotation)))) {
            result = (String)AnnotationUtils.getValue(annotation);
        }
        return result;
    }
}

