/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.dfs;

import com.oembedler.moon.graphql.engine.GraphQLSchemaConfig;
import com.oembedler.moon.graphql.engine.dfs.MappingConstants;
import com.oembedler.moon.graphql.engine.type.GraphQLDateType;
import com.oembedler.moon.graphql.engine.type.GraphQLLocalDateTimeType;
import graphql.schema.GraphQLScalarType;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.Date;
import org.springframework.util.Assert;

public class GraphQLMappingContext {
    private final GraphQLSchemaConfig graphQLSchemaConfig;

    public GraphQLMappingContext(GraphQLSchemaConfig graphQLSchemaConfig) {
        Assert.notNull((Object)graphQLSchemaConfig, (String)"GraphQL Schema config must not be null");
        this.graphQLSchemaConfig = graphQLSchemaConfig;
    }

    public GraphQLScalarType getScalarGraphQLType(Type cls) {
        GraphQLScalarType graphQLScalarType = MappingConstants.getScalarGraphQLType(cls);
        if (Date.class.isAssignableFrom((Class)cls)) {
            graphQLScalarType = this.graphQLSchemaConfig.isDateAsTimestamp() ? MappingConstants.graphQLTimestamp : this.getGraphQLDateType();
        } else if (LocalDateTime.class.isAssignableFrom((Class)cls)) {
            graphQLScalarType = this.graphQLSchemaConfig.isDateAsTimestamp() ? MappingConstants.graphQLTimestamp : this.getGraphQLDateType();
        }
        return graphQLScalarType;
    }

    private GraphQLScalarType getGraphQLDateType() {
        return new GraphQLDateType("Date", "Date formatted according to defined format string", this.graphQLSchemaConfig.getDateFormat());
    }

    private GraphQLScalarType getGraphQLLocalDateTimeType() {
        return new GraphQLLocalDateTimeType("LocalDateTime", "LocalDateTime formatted according to defined format string", this.graphQLSchemaConfig.getDateFormat());
    }
}

