/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.dfs;

import com.oembedler.moon.graphql.engine.dfs.MethodParameters;
import com.oembedler.moon.graphql.engine.dfs.ResolvableTypeAccessor;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLIn;
import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;
import org.springframework.util.StringUtils;

public class GraphQLMethodParameters
extends MethodParameters {
    private final Class<?> returnType;
    private final String returnTypeName;

    public GraphQLMethodParameters(Method method, Class<?> implClass) {
        super(method, implClass);
        ResolvableTypeAccessor resolvableTypeAccessor = ResolvableTypeAccessor.forMethodReturnType(method, implClass);
        this.returnType = resolvableTypeAccessor.resolve();
        this.returnTypeName = resolvableTypeAccessor.getGraphQLOutName();
    }

    @Override
    protected String getParameterName(int idx, MethodParameter methodParameter) {
        String inputParameterName = null;
        GraphQLIn graphQLIn = (GraphQLIn)methodParameter.getParameterAnnotation(GraphQLIn.class);
        if (graphQLIn != null && StringUtils.hasLength((String)graphQLIn.value())) {
            inputParameterName = graphQLIn.value();
        }
        return inputParameterName;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public String getReturnTypeName() {
        return this.returnTypeName;
    }
}

