/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.dfs;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.oembedler.moon.graphql.GraphQLSchemaBeanFactory;
import com.oembedler.moon.graphql.engine.CompleteObjectTreeTypeResolver;
import com.oembedler.moon.graphql.engine.GraphQLSchemaConfig;
import com.oembedler.moon.graphql.engine.ReflectionGraphQLDataFetcher;
import com.oembedler.moon.graphql.engine.ReflectionGraphQLDataMutator;
import com.oembedler.moon.graphql.engine.StereotypeUtils;
import com.oembedler.moon.graphql.engine.dfs.GraphQLFieldDefinitionWrapper;
import com.oembedler.moon.graphql.engine.dfs.GraphQLMappingContext;
import com.oembedler.moon.graphql.engine.dfs.GraphQLMethodParameters;
import com.oembedler.moon.graphql.engine.dfs.ResolvableTypeAccessor;
import com.oembedler.moon.graphql.engine.dfs.SchemaHelper;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLInterface;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLSchemaQuery;
import com.oembedler.moon.graphql.engine.type.GraphQLEnumTypeExt;
import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.TypeResolver;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedRuntimeException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class GraphQLSchemaDfsTraversal {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLSchemaDfsTraversal.class);
    private static final ExpressionParser SPEL_EXPRESSION_PARSER = new SpelExpressionParser();
    private String schemaName;
    private final Class<?> schemaClass;
    private final GraphQLSchemaConfig graphQLSchemaConfig;
    private final GraphQLSchemaBeanFactory graphQLSchemaBeanFactory;
    private final GraphQLMappingContext graphQLMappingContext;
    private final ConcurrentHashMap<Class<?>, String> objectTypeNameReferenceMap;
    private final ConcurrentHashMap<String, Class<?>> objectNameTypeReferenceMap;
    private final ConcurrentHashMap<Class<?>, GraphQLType> objectTypeResolverMap;
    private final Map<String, Map<Class<?>, GraphQLOutputType>> mutationReturnTypeResolverMap;
    private final Map<String, Map<Class<?>, GraphQLInputObjectField>> mutationInputTypeResolverMap;
    private final Map<GraphQLFieldDefinition, GraphQLFieldDefinitionWrapper> fieldDefinitionResolverMap;
    private final Set<GraphQLUnionType> graphQLUnionTypeMap;

    public GraphQLSchemaDfsTraversal(Class<?> schemaClass, GraphQLSchemaConfig graphQLSchemaConfig, GraphQLSchemaBeanFactory graphQLSchemaBeanFactory) {
        this.schemaClass = schemaClass;
        this.graphQLSchemaConfig = graphQLSchemaConfig;
        this.graphQLSchemaBeanFactory = graphQLSchemaBeanFactory;
        this.graphQLMappingContext = new GraphQLMappingContext(this.graphQLSchemaConfig);
        this.objectTypeResolverMap = new ConcurrentHashMap();
        this.objectTypeNameReferenceMap = new ConcurrentHashMap();
        this.objectNameTypeReferenceMap = new ConcurrentHashMap();
        this.mutationReturnTypeResolverMap = new LinkedHashMap();
        this.mutationInputTypeResolverMap = new LinkedHashMap();
        this.fieldDefinitionResolverMap = new LinkedHashMap<GraphQLFieldDefinition, GraphQLFieldDefinitionWrapper>();
        this.graphQLUnionTypeMap = new HashSet<GraphQLUnionType>();
    }

    public GraphQLSchema traverse() {
        this.schemaName = StereotypeUtils.getGraphQLSchemaName(this.schemaClass, this.schemaClass.getName());
        DfsContext dfsContext = new DfsContext();
        GraphQLObjectType graphQLRootQueryObjectType = (GraphQLObjectType)this.findSchemaQueryRoot(dfsContext, this.schemaClass);
        GraphQLObjectType graphQLMutationObjectType = this.findSchemaMutations(dfsContext, this.schemaClass);
        GraphQLSchema graphQLSchema = GraphQLSchema.newSchema().query(graphQLRootQueryObjectType).mutation(graphQLMutationObjectType).build();
        SchemaHelper.replaceTypeReferencesForUnionType(graphQLSchema, this.graphQLUnionTypeMap);
        return graphQLSchema;
    }

    public GraphQLType findSchemaQueryRoot(DfsContext dfsContext, Class<?> classSchema) {
        Set fields = org.reflections.ReflectionUtils.getAllFields(classSchema, (Predicate[])new Predicate[]{org.reflections.ReflectionUtils.withAnnotation(GraphQLSchemaQuery.class)});
        if (fields.size() == 0) {
            throw new GraphQLSchemaTraversalRuntimeException("No GraphQL schema root query found");
        }
        return this.createGraphQLObjectTypeRecursively(dfsContext, ((Field)fields.iterator().next()).getType());
    }

    public GraphQLType createGraphQLObjectTypeRecursively(DfsContext dfsContext, Class<?> implClass) {
        ResolvableTypeAccessor resolvableTypeAccessor = ResolvableTypeAccessor.forClass(implClass);
        String objectName = resolvableTypeAccessor.getName();
        String objectDescription = resolvableTypeAccessor.getDescription();
        GraphQLType graphQLObjectType = this.objectTypeResolverMap.get(implClass);
        if (!this.objectTypeNameReferenceMap.containsKey(implClass)) {
            this.objectTypeNameReferenceMap.put(implClass, objectName);
            this.objectNameTypeReferenceMap.put(objectName, implClass);
            ArrayList graphQLFieldDefinitions = new ArrayList();
            if (implClass.isEnum()) {
                graphQLObjectType = this.buildGraphQLEnumType(dfsContext, resolvableTypeAccessor);
            } else {
                org.reflections.ReflectionUtils.getAllFields(implClass, (Predicate[])new Predicate[0]).forEach(field -> {
                    GraphQLFieldDefinition definition = this.getFieldDefinition(dfsContext, implClass, (Field)field);
                    if (definition != null) {
                        graphQLFieldDefinitions.add(definition);
                    }
                });
                org.reflections.ReflectionUtils.getAllMethods(implClass, (Predicate[])new Predicate[0]).forEach(method -> {
                    GraphQLFieldDefinition definition = this.getMethodDefinition(dfsContext, implClass, (Method)method);
                    if (definition != null) {
                        graphQLFieldDefinitions.add(definition);
                    }
                });
                ArrayList graphQLInterfaceTypes = Lists.newArrayList();
                if (implClass.isInterface()) {
                    if (resolvableTypeAccessor.isGraphQLUnion()) {
                        ArrayList<GraphQLType> possibleTypes = new ArrayList<GraphQLType>();
                        for (Class<?> possibleType : resolvableTypeAccessor.getGraphQLUnionPossibleTypes()) {
                            possibleTypes.add(this.createGraphQLObjectTypeRecursively(dfsContext, possibleType));
                        }
                        graphQLObjectType = GraphQLUnionType.newUnionType().name(resolvableTypeAccessor.getName()).possibleTypes(possibleTypes.toArray(new GraphQLType[possibleTypes.size()])).typeResolver((TypeResolver)new CompleteObjectTreeTypeResolver(this.objectTypeResolverMap)).description(resolvableTypeAccessor.getDescription()).build();
                        this.graphQLUnionTypeMap.add((GraphQLUnionType)graphQLObjectType);
                    } else {
                        graphQLObjectType = GraphQLInterfaceType.newInterface().name(objectName).description(objectDescription).fields(graphQLFieldDefinitions).typeResolver((TypeResolver)new CompleteObjectTreeTypeResolver(this.objectTypeResolverMap)).build();
                    }
                } else {
                    ClassUtils.getAllInterfacesForClassAsSet(implClass).forEach(aClass -> {
                        if (this.isAcceptableInterface(dfsContext, (Class<?>)aClass)) {
                            GraphQLType graphQLType = this.createGraphQLObjectTypeRecursively(dfsContext, (Class<?>)aClass);
                            graphQLInterfaceTypes.add(graphQLType);
                        }
                    });
                    graphQLObjectType = GraphQLObjectType.newObject().name(objectName).description(objectDescription).fields(graphQLFieldDefinitions).withInterfaces(this.resolveInterfaceReferences(dfsContext, graphQLInterfaceTypes)).build();
                }
            }
            this.objectTypeResolverMap.put(implClass, graphQLObjectType);
        } else {
            graphQLObjectType = new GraphQLTypeReference(objectName);
        }
        return graphQLObjectType;
    }

    public GraphQLInterfaceType[] resolveInterfaceReferences(DfsContext dfsContext, List<GraphQLType> graphQLInterfaceTypes) {
        GraphQLInterfaceType[] interfaceTypes = new GraphQLInterfaceType[graphQLInterfaceTypes.size()];
        for (int i = 0; i < graphQLInterfaceTypes.size(); ++i) {
            GraphQLType type = graphQLInterfaceTypes.get(i);
            if (type instanceof GraphQLTypeReference) {
                Class<?> cls = this.objectNameTypeReferenceMap.get(type.getName());
                type = this.objectTypeResolverMap.get(cls);
            }
            interfaceTypes[i] = (GraphQLInterfaceType)type;
        }
        return interfaceTypes;
    }

    public GraphQLEnumType buildGraphQLEnumType(DfsContext dfsContext, ResolvableTypeAccessor resolvableTypeAccessor) {
        Class<?> implClass = resolvableTypeAccessor.getImplClass();
        Enum[] enumList = (Enum[])implClass.getEnumConstants();
        String valueProviderMethod = resolvableTypeAccessor.getGraphQLEnumValueProviderMethodName();
        String valueSpel = resolvableTypeAccessor.getGraphQLEnumDefaultValueSpel();
        GraphQLEnumTypeExt.Builder enumTypeBuilder = new GraphQLEnumTypeExt.Builder().name(resolvableTypeAccessor.getName()).description(resolvableTypeAccessor.getDescription());
        if (enumList != null) {
            for (Enum en : enumList) {
                ResolvableTypeAccessor rta = ResolvableTypeAccessor.forEnumField(en);
                String description = rta.getDescription();
                String enumName = rta.getName();
                Object value = enumName;
                if (StringUtils.hasText((String)valueProviderMethod)) {
                    value = this.invokeMethodByName(dfsContext, implClass, valueProviderMethod, en);
                }
                value = this.evaluateSpElExpression(dfsContext, implClass, en, valueSpel, value);
                enumTypeBuilder.value(enumName, value, description);
            }
        }
        GraphQLEnumType enumType = enumTypeBuilder.build();
        return enumType;
    }

    public boolean isAcceptableInterface(DfsContext dfsContext, Class<?> aClass) {
        return aClass.isAnnotationPresent(GraphQLInterface.class);
    }

    public GraphQLFieldDefinition getMethodDefinition(DfsContext dfsContext, Class<?> objectClass, Method method) {
        GraphQLFieldDefinition graphQLFieldDefinition = null;
        ResolvableTypeAccessor resolvableTypeAccessor = ResolvableTypeAccessor.forMethodReturnType(method, objectClass);
        if (resolvableTypeAccessor.isGraphQLIdOrGraphQLField()) {
            GraphQLOutputType graphQLOutputType = (GraphQLOutputType)this.createGraphQLFieldType(dfsContext, resolvableTypeAccessor, true);
            List<GraphQLArgument> graphQLArguments = this.buildGraphQLArgumentsFromMethodParams(dfsContext, method, objectClass);
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition().name(resolvableTypeAccessor.getName()).deprecate(resolvableTypeAccessor.getGraphQLDeprecationReason()).argument(graphQLArguments).type(graphQLOutputType).description(resolvableTypeAccessor.getDescription());
            if (!objectClass.isInterface()) {
                String beanName = objectClass.getName() + resolvableTypeAccessor.getName();
                Object object = this.getGraphQLSchemaBeanFactory().getBeanByType(objectClass);
                builder.dataFetcher((DataFetcher)new ReflectionGraphQLDataFetcher(this.getGraphQLSchemaConfig(), object, method));
            }
            graphQLFieldDefinition = builder.build();
            this.addToFieldDefinitionResolverMap(dfsContext, graphQLFieldDefinition, resolvableTypeAccessor.getGraphQLComplexitySpelExpression());
        }
        return graphQLFieldDefinition;
    }

    public GraphQLFieldDefinition getFieldDefinition(DfsContext dfsContext, Class<?> implClass, Field field) {
        GraphQLFieldDefinition graphQLFieldDefinition = null;
        ResolvableTypeAccessor resolvableTypeAccessor = ResolvableTypeAccessor.forField(field, implClass);
        if (resolvableTypeAccessor.isNotIgnorable()) {
            boolean isConstant;
            GraphQLOutputType graphQLOutputType = (GraphQLOutputType)this.createGraphQLFieldType(dfsContext, resolvableTypeAccessor, true);
            GraphQLFieldDefinition.Builder graphQLFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition().name(resolvableTypeAccessor.getName()).type(graphQLOutputType).deprecate(resolvableTypeAccessor.getGraphQLDeprecationReason()).description(resolvableTypeAccessor.getDescription());
            boolean bl = isConstant = Modifier.isFinal(field.getModifiers()) && Modifier.isStatic(field.getModifiers());
            if (isConstant) {
                graphQLFieldDefinitionBuilder.staticValue(ReflectionUtils.getField((Field)field, null));
            }
            graphQLFieldDefinition = graphQLFieldDefinitionBuilder.build();
            this.addToFieldDefinitionResolverMap(dfsContext, graphQLFieldDefinition, resolvableTypeAccessor.getGraphQLComplexitySpelExpression());
        }
        return graphQLFieldDefinition;
    }

    public void addToFieldDefinitionResolverMap(DfsContext dfsContext, GraphQLFieldDefinition graphQLFieldDefinition, String complexitySpelExpression) {
        this.fieldDefinitionResolverMap.put(graphQLFieldDefinition, new GraphQLFieldDefinitionWrapper(graphQLFieldDefinition, complexitySpelExpression));
    }

    public GraphQLType createGraphQLFieldType(DfsContext dfsContext, ResolvableTypeAccessor resolvableTypeAccessor, boolean isRecursive) {
        Object graphQLType;
        boolean isContainer = resolvableTypeAccessor.isCollectionLike();
        Class<?> cls = resolvableTypeAccessor.getActualType();
        GraphQLScalarType graphQLScalarType = graphQLType = resolvableTypeAccessor.isGraphQLId() ? Scalars.GraphQLID : this.getGraphQLMappingContext().getScalarGraphQLType(cls);
        if (graphQLType == null && isRecursive) {
            graphQLType = this.createGraphQLObjectTypeRecursively(dfsContext, cls);
        }
        if (graphQLType != null) {
            graphQLType = isContainer ? new GraphQLList((GraphQLType)graphQLType) : (resolvableTypeAccessor.isNotNull() ? new GraphQLNonNull((GraphQLType)graphQLType) : graphQLType);
        }
        return graphQLType;
    }

    public List<GraphQLArgument> buildGraphQLArgumentsFromMethodParams(DfsContext dfsContext, Method method, Class<?> implClass) {
        ArrayList<GraphQLArgument> graphQLArguments = new ArrayList<GraphQLArgument>();
        GraphQLMethodParameters graphQLMethodParameters = new GraphQLMethodParameters(method, implClass);
        if (graphQLMethodParameters.hasParameters()) {
            graphQLMethodParameters.getParameters().forEach(mpi -> {
                Object defaultValue = this.invokeMethodByName(dfsContext, implClass, mpi.getGraphQLInDefaultValueProviderMethodName(), new Object[0]);
                defaultValue = this.evaluateSpElExpression(dfsContext, implClass, null, mpi.getGraphQLInDefaultValueSpel(), defaultValue);
                if (mpi.isValidGraphQLInParameter()) {
                    GraphQLArgument graphQLArgument = GraphQLArgument.newArgument().name(mpi.getName()).description(mpi.getDescription()).type(this.buildGraphQLInputTypeFromMethodParam(dfsContext, mpi.getResolvableTypeAccessor())).defaultValue(defaultValue).build();
                    graphQLArguments.add(graphQLArgument);
                }
            });
        }
        return graphQLArguments;
    }

    public Object evaluateSpElExpression(DfsContext dfsContext, Class<?> implClass, Object instance, String spElExpression, Object defaultIfNone) {
        Object defaultValue = defaultIfNone;
        if (StringUtils.hasText((String)spElExpression)) {
            Expression expression = SPEL_EXPRESSION_PARSER.parseExpression(spElExpression);
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("cls", implClass);
            context.setVariable("obj", instance);
            defaultValue = expression.getValue((EvaluationContext)context);
        }
        return defaultValue;
    }

    public Object invokeMethodByName(DfsContext dfsContext, Class<?> implClass, String methodName, Object ... args) {
        Object defaultValue = null;
        if (StringUtils.hasText((String)methodName)) {
            Method defaultValueProviderMethod;
            Object object = null;
            if (this.getGraphQLSchemaBeanFactory().containsBean(implClass)) {
                object = this.getGraphQLSchemaBeanFactory().getBeanByType(implClass);
            }
            Method method = defaultValueProviderMethod = args == null ? ReflectionUtils.findMethod(implClass, (String)methodName) : ReflectionUtils.findMethod(implClass, (String)methodName, (Class[])this.getArgumentClasses(args));
            if (defaultValueProviderMethod != null) {
                defaultValue = ReflectionUtils.invokeMethod((Method)defaultValueProviderMethod, object, (Object[])args);
            }
        }
        return defaultValue;
    }

    private Class<?>[] getArgumentClasses(Object[] args) {
        Class[] argClasses = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            argClasses[i] = args[i].getClass();
        }
        return argClasses;
    }

    public GraphQLInputType buildGraphQLInputTypeFromMethodParam(DfsContext dfsContext, ResolvableTypeAccessor resolvableTypeAccessor) {
        Class<?> cls = resolvableTypeAccessor.resolve();
        GraphQLInputType graphQLInputObjectType = (GraphQLInputType)this.objectTypeResolverMap.get(cls);
        if (graphQLInputObjectType == null) {
            graphQLInputObjectType = (GraphQLInputType)this.createGraphQLFieldType(dfsContext, resolvableTypeAccessor, false);
        }
        if (graphQLInputObjectType == null) {
            ArrayList graphQLInputFieldDefinitions = new ArrayList();
            org.reflections.ReflectionUtils.getAllFields(cls, (Predicate[])new Predicate[0]).forEach(field -> {
                GraphQLInputObjectField definition = this.buildGraphQLInputObjectField(dfsContext, (Field)field, cls);
                if (definition != null) {
                    graphQLInputFieldDefinitions.add(definition);
                }
            });
            graphQLInputObjectType = GraphQLInputObjectType.newInputObject().name(cls.getSimpleName()).description(resolvableTypeAccessor.getDescription()).fields(graphQLInputFieldDefinitions).build();
        }
        return graphQLInputObjectType;
    }

    public GraphQLInputObjectField buildGraphQLInputObjectField(DfsContext dfsContext, Field field, Class<?> implClass) {
        ResolvableTypeAccessor resolvableTypeAccessor = ResolvableTypeAccessor.forField(field, implClass);
        Object defaultValue = this.invokeMethodByName(dfsContext, implClass, resolvableTypeAccessor.getGraphQLInDefaultValueProviderMethodName(), new Object[0]);
        defaultValue = this.evaluateSpElExpression(dfsContext, implClass, null, resolvableTypeAccessor.getGraphQLInDefaultValueSpel(), defaultValue);
        GraphQLInputObjectField graphQLInputObjectField = GraphQLInputObjectField.newInputObjectField().name(resolvableTypeAccessor.getName()).description(resolvableTypeAccessor.getDescription()).defaultValue(defaultValue).type(this.buildGraphQLInputTypeFromMethodParam(dfsContext, resolvableTypeAccessor)).build();
        return graphQLInputObjectField;
    }

    public GraphQLObjectType findSchemaMutations(DfsContext dfsContext, Class<?> implClass) {
        List<GraphQLFieldDefinition> graphQLFieldDefinitions = this.findSchemaMutationsFields(dfsContext, implClass);
        return GraphQLObjectType.newObject().name(this.getGraphQLSchemaConfig().getSchemaMutationObjectName()).fields(graphQLFieldDefinitions).build();
    }

    public List<GraphQLFieldDefinition> findSchemaMutationsFields(DfsContext dfsContext, Class<?> implClass) {
        ArrayList<GraphQLFieldDefinition> graphQLFieldDefinitions = new ArrayList<GraphQLFieldDefinition>();
        org.reflections.ReflectionUtils.getAllMethods(implClass, (Predicate[])new Predicate[0]).forEach(method -> {
            ResolvableTypeAccessor methodReturnTypeResolvableTypeAccessor = ResolvableTypeAccessor.forMethodReturnType(method, implClass);
            if (methodReturnTypeResolvableTypeAccessor.isGraphQLMutation()) {
                String beanName = implClass.getName() + methodReturnTypeResolvableTypeAccessor.getName();
                Object object = this.getGraphQLSchemaBeanFactory().getBeanByType(implClass);
                String mutationName = StereotypeUtils.getGraphQLMutationName(method, methodReturnTypeResolvableTypeAccessor.getName());
                GraphQLObjectType graphQLOutputObjectType = this.createGraphQLOutputObjectType(dfsContext, mutationName, methodReturnTypeResolvableTypeAccessor);
                GraphQLInputType graphQLInputType = this.createGraphQLInputObjectType(dfsContext, mutationName, (Method)method, implClass);
                GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(mutationName).description(methodReturnTypeResolvableTypeAccessor.getDescription()).deprecate(methodReturnTypeResolvableTypeAccessor.getGraphQLDeprecationReason()).type((GraphQLOutputType)graphQLOutputObjectType).dataFetcher((DataFetcher)new ReflectionGraphQLDataMutator(this.graphQLSchemaConfig, object, (Method)method));
                if (graphQLInputType != null) {
                    fieldBuilder.argument(GraphQLArgument.newArgument().name(this.getGraphQLSchemaConfig().getMutationInputArgumentName()).type(graphQLInputType).build());
                }
                GraphQLFieldDefinition mutationField = fieldBuilder.build();
                this.addToFieldDefinitionResolverMap(dfsContext, mutationField, methodReturnTypeResolvableTypeAccessor.getGraphQLComplexitySpelExpression());
                graphQLFieldDefinitions.add(mutationField);
            }
        });
        return graphQLFieldDefinitions;
    }

    public GraphQLObjectType createGraphQLOutputObjectType(DfsContext dfsContext, String mutationName, ResolvableTypeAccessor resolvableTypeAccessor) {
        Class<?> cls = resolvableTypeAccessor.resolve();
        GraphQLType graphQLObjectType = this.objectTypeResolverMap.get(cls);
        if (graphQLObjectType == null) {
            graphQLObjectType = this.createGraphQLFieldType(dfsContext, resolvableTypeAccessor, true);
        }
        GraphQLScalarType clientMutationIdType = this.getGraphQLSchemaConfig().isAllowEmptyClientMutationId() ? Scalars.GraphQLString : new GraphQLNonNull((GraphQLType)Scalars.GraphQLString);
        this.addToMutationReturnTypeResolverMap(dfsContext, mutationName, cls, (GraphQLOutputType)graphQLObjectType);
        GraphQLFieldDefinition graphQLFieldDefinition = GraphQLFieldDefinition.newFieldDefinition().name(resolvableTypeAccessor.getGraphQLOutName()).deprecate(resolvableTypeAccessor.getGraphQLDeprecationReason()).description(resolvableTypeAccessor.getDescription()).type((GraphQLOutputType)graphQLObjectType).build();
        this.addToFieldDefinitionResolverMap(dfsContext, graphQLFieldDefinition, resolvableTypeAccessor.getGraphQLComplexitySpelExpression());
        return GraphQLObjectType.newObject().name(resolvableTypeAccessor.getName() + this.getGraphQLSchemaConfig().getOutputObjectNamePrefix()).field(GraphQLFieldDefinition.newFieldDefinition().name(this.getGraphQLSchemaConfig().getClientMutationIdName()).type((GraphQLOutputType)clientMutationIdType).build()).field(graphQLFieldDefinition).build();
    }

    public void addToMutationReturnTypeResolverMap(DfsContext dfsContext, String mutationName, Class<?> implClass, GraphQLOutputType graphQLOutputType) {
        Map<Class<?>, GraphQLOutputType> mutationMap = this.mutationReturnTypeResolverMap.get(mutationName);
        if (mutationMap == null) {
            mutationMap = new LinkedHashMap();
        }
        mutationMap.put(implClass, graphQLOutputType);
        this.mutationReturnTypeResolverMap.put(mutationName, mutationMap);
    }

    public GraphQLInputType createGraphQLInputObjectType(DfsContext dfsContext, String mutationName, Method method, Class<?> implClass) {
        ArrayList graphQLInputObjectFields = new ArrayList();
        GraphQLMethodParameters graphQLMethodParameters = new GraphQLMethodParameters(method, implClass);
        if (graphQLMethodParameters.hasParameters()) {
            graphQLMethodParameters.getParameters().forEach(mpi -> {
                GraphQLInputType graphQLInputType;
                if (mpi.isValidGraphQLInParameter() && (graphQLInputType = this.buildGraphQLInputTypeFromMethodParam(dfsContext, mpi.getResolvableTypeAccessor())) != null) {
                    graphQLInputType = mpi.isRequired() ? new GraphQLNonNull((GraphQLType)graphQLInputType) : graphQLInputType;
                    Object defaultValue = this.invokeMethodByName(dfsContext, implClass, mpi.getGraphQLInDefaultValueProviderMethodName(), new Object[0]);
                    defaultValue = this.evaluateSpElExpression(dfsContext, implClass, null, mpi.getGraphQLInDefaultValueSpel(), defaultValue);
                    GraphQLInputObjectField graphQLInputObjectField = GraphQLInputObjectField.newInputObjectField().name(mpi.getName()).type(graphQLInputType).description(mpi.getDescription()).defaultValue(defaultValue).build();
                    graphQLInputObjectFields.add(graphQLInputObjectField);
                    this.addToMutationInputTypeResolverMap(dfsContext, mutationName, mpi.getParameterType(), graphQLInputObjectField);
                }
            });
        }
        GraphQLScalarType clientMutationIdType = this.getGraphQLSchemaConfig().isAllowEmptyClientMutationId() ? Scalars.GraphQLString : new GraphQLNonNull((GraphQLType)Scalars.GraphQLString);
        String inputObjectName = StereotypeUtils.getGraphQLMutationName(method, method.getName());
        GraphQLInputObjectType inputObjectType = GraphQLInputObjectType.newInputObject().name(inputObjectName + this.getGraphQLSchemaConfig().getInputObjectNamePrefix()).field(GraphQLInputObjectField.newInputObjectField().name(this.getGraphQLSchemaConfig().getClientMutationIdName()).type((GraphQLInputType)clientMutationIdType).build()).fields(graphQLInputObjectFields).build();
        return new GraphQLNonNull((GraphQLType)inputObjectType);
    }

    public void addToMutationInputTypeResolverMap(DfsContext dfsContext, String mutationName, Class<?> implClass, GraphQLInputObjectField graphQLInputObjectField) {
        Map<Class<?>, GraphQLInputObjectField> mutationMap = this.mutationInputTypeResolverMap.get(mutationName);
        if (mutationMap == null) {
            mutationMap = new LinkedHashMap();
        }
        mutationMap.put(implClass, graphQLInputObjectField);
        this.mutationInputTypeResolverMap.put(mutationName, mutationMap);
    }

    public GraphQLSchemaBeanFactory getGraphQLSchemaBeanFactory() {
        return this.graphQLSchemaBeanFactory;
    }

    public ConcurrentHashMap<Class<?>, GraphQLType> getObjectTypeResolverMap() {
        return this.objectTypeResolverMap;
    }

    public GraphQLSchemaConfig getGraphQLSchemaConfig() {
        return this.graphQLSchemaConfig;
    }

    public Map<String, Map<Class<?>, GraphQLOutputType>> getMutationReturnTypeResolverMap() {
        return this.mutationReturnTypeResolverMap;
    }

    public Map<String, Map<Class<?>, GraphQLInputObjectField>> getMutationInputTypeResolverMap() {
        return this.mutationInputTypeResolverMap;
    }

    public Map<GraphQLFieldDefinition, GraphQLFieldDefinitionWrapper> getFieldDefinitionResolverMap() {
        return this.fieldDefinitionResolverMap;
    }

    public ConcurrentHashMap<Class<?>, String> getObjectTypeNameReferenceMap() {
        return this.objectTypeNameReferenceMap;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public GraphQLMappingContext getGraphQLMappingContext() {
        return this.graphQLMappingContext;
    }

    public static class GraphQLSchemaTraversalRuntimeException
    extends NestedRuntimeException {
        public GraphQLSchemaTraversalRuntimeException(String msg) {
            super(msg);
        }
    }

    private class DfsContext {
        private DfsContext() {
        }
    }
}

