/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.dfs;

import graphql.GraphQLException;
import graphql.Scalars;
import graphql.language.FloatValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MappingConstants {
    private static final Map<Type, GraphQLScalarType> GRAPHQL_SCALARS_TYPE_MAP = new HashMap<Type, GraphQLScalarType>();
    public static GraphQLScalarType graphQLTimestamp = new GraphQLScalarType("Timestamp", "Timestamp since 1970 Jan 1st", new Coercing(){

        public Object serialize(Object input) {
            if (input instanceof String) {
                return new Date(Long.parseLong((String)input));
            }
            if (input instanceof Date) {
                return (Date)input;
            }
            if (input instanceof Integer) {
                return new Date(((Integer)input).longValue());
            }
            if (input instanceof Long) {
                return new Date((Long)input);
            }
            throw new GraphQLException("Wrong timestamp value");
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            return new Date(Long.parseLong(((StringValue)input).getValue()));
        }
    });
    public static GraphQLScalarType GraphQLDouble = new GraphQLScalarType("Double", "Built-in Double", new Coercing(){

        public Object serialize(Object input) {
            if (input instanceof String) {
                return Double.parseDouble((String)input);
            }
            if (input instanceof Double) {
                return input;
            }
            throw new GraphQLException();
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            return ((FloatValue)input).getValue().doubleValue();
        }
    });

    public static GraphQLScalarType getScalarGraphQLType(Type cls) {
        return GRAPHQL_SCALARS_TYPE_MAP.get(cls);
    }

    static {
        GRAPHQL_SCALARS_TYPE_MAP.put(Boolean.TYPE, Scalars.GraphQLBoolean);
        GRAPHQL_SCALARS_TYPE_MAP.put(Byte.TYPE, Scalars.GraphQLInt);
        GRAPHQL_SCALARS_TYPE_MAP.put(Character.TYPE, Scalars.GraphQLString);
        GRAPHQL_SCALARS_TYPE_MAP.put(Double.TYPE, GraphQLDouble);
        GRAPHQL_SCALARS_TYPE_MAP.put(Float.TYPE, Scalars.GraphQLFloat);
        GRAPHQL_SCALARS_TYPE_MAP.put(Integer.TYPE, Scalars.GraphQLInt);
        GRAPHQL_SCALARS_TYPE_MAP.put(Long.TYPE, Scalars.GraphQLLong);
        GRAPHQL_SCALARS_TYPE_MAP.put((Type)((Object)Boolean.class), Scalars.GraphQLBoolean);
        GRAPHQL_SCALARS_TYPE_MAP.put((Type)((Object)Byte.class), Scalars.GraphQLInt);
        GRAPHQL_SCALARS_TYPE_MAP.put((Type)((Object)Short.class), Scalars.GraphQLInt);
        GRAPHQL_SCALARS_TYPE_MAP.put((Type)((Object)Integer.class), Scalars.GraphQLInt);
        GRAPHQL_SCALARS_TYPE_MAP.put((Type)((Object)Long.class), Scalars.GraphQLLong);
        GRAPHQL_SCALARS_TYPE_MAP.put((Type)((Object)Float.class), Scalars.GraphQLFloat);
        GRAPHQL_SCALARS_TYPE_MAP.put((Type)((Object)Character.class), Scalars.GraphQLString);
        GRAPHQL_SCALARS_TYPE_MAP.put((Type)((Object)String.class), Scalars.GraphQLString);
        GRAPHQL_SCALARS_TYPE_MAP.put((Type)((Object)Double.class), GraphQLDouble);
    }
}

