/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.dfs;

import com.google.common.collect.Lists;
import com.oembedler.moon.graphql.engine.dfs.ResolvableTypeAccessor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.StringUtils;

public abstract class MethodParameters {
    private final Method targetMethod;
    private final Class<?> implClass;
    private final String[] autoDiscoveredNames;
    private MethodParameterInfo[] methodParameterInfos;
    private final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    public MethodParameters(Method targetMethod, Class<?> implClass) {
        this.targetMethod = targetMethod;
        this.implClass = implClass;
        this.autoDiscoveredNames = this.parameterNameDiscoverer.getParameterNames(this.targetMethod);
        this.discoverMethodParameters();
    }

    public void discoverMethodParameters() {
        if (this.methodParameterInfos == null) {
            this.methodParameterInfos = new MethodParameterInfo[this.targetMethod.getParameterCount()];
            for (int i = 0; i < this.targetMethod.getParameterCount(); ++i) {
                MethodParameter methodParameter = new MethodParameter(this.targetMethod, i);
                String inputParameterName = this.getParameterName(i, methodParameter);
                if (StringUtils.isEmpty((Object)inputParameterName)) {
                    inputParameterName = this.getAutoDiscoveredName(i);
                }
                ResolvableTypeAccessor resolvableTypeAccessor = ResolvableTypeAccessor.forMethodParameter(this.targetMethod, i, this.implClass);
                this.methodParameterInfos[i] = new MethodParameterInfo(i, inputParameterName, resolvableTypeAccessor);
            }
        }
    }

    public List<MethodParameterInfo> getParameters() {
        return this.methodParameterInfos == null ? Collections.EMPTY_LIST : Lists.newArrayList((Object[])this.methodParameterInfos);
    }

    public int getNumberOfParameters() {
        return this.methodParameterInfos == null ? 0 : this.methodParameterInfos.length;
    }

    public boolean isCompatibleWith(int argIdx, Class<?> cls) {
        return this.methodParameterInfos[argIdx].getParameterType().isAssignableFrom(cls);
    }

    private String getAutoDiscoveredName(int idx) {
        return this.autoDiscoveredNames != null && this.autoDiscoveredNames.length > 0 && idx < this.autoDiscoveredNames.length ? this.autoDiscoveredNames[idx] : null;
    }

    protected abstract String getParameterName(int var1, MethodParameter var2);

    public boolean hasParameters() {
        return this.methodParameterInfos != null && this.methodParameterInfos.length > 0;
    }

    public boolean hasNoParameters() {
        return !this.hasParameters();
    }

    public static class MethodParameterInfo {
        private final int idx;
        private final String name;
        private final boolean isRequired;
        private final ResolvableTypeAccessor resolvableTypeAccessor;

        public MethodParameterInfo(int idx, String name, ResolvableTypeAccessor resolvableTypeAccessor) {
            this.idx = idx;
            this.name = name;
            this.resolvableTypeAccessor = resolvableTypeAccessor;
            this.isRequired = resolvableTypeAccessor.isRequiredGraphQLInParameter();
        }

        public int getIdx() {
            return this.idx;
        }

        public String getName() {
            return this.name;
        }

        public ResolvableTypeAccessor getResolvableTypeAccessor() {
            return this.resolvableTypeAccessor;
        }

        public Class<?> getRawType() {
            return this.getResolvableTypeAccessor().resolve();
        }

        public String getDescription() {
            return this.getResolvableTypeAccessor().getDescription();
        }

        public Class<?> getParameterType() {
            return this.getResolvableTypeAccessor().getActualType();
        }

        public boolean isCollectionLike() {
            return this.getResolvableTypeAccessor().isCollectionLike();
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public boolean isGraphQLInParameter() {
            return this.getResolvableTypeAccessor().isGraphQLInParameter();
        }

        public String getGraphQLInDefaultValueProviderMethodName() {
            return this.getResolvableTypeAccessor().getGraphQLInDefaultValueProviderMethodName();
        }

        public String getGraphQLInDefaultValueSpel() {
            return this.getResolvableTypeAccessor().getGraphQLInDefaultValueSpel();
        }

        public boolean isValidGraphQLInParameter() {
            return StringUtils.hasText((String)this.getName()) && this.isGraphQLInParameter();
        }
    }
}

