/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.dfs;

import com.google.common.collect.Lists;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLComplexity;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLDeprecate;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLDescription;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLEnum;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLField;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLID;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLIgnore;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLIn;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLInterface;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLMutation;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLNonNull;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLObject;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLOut;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLUnion;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ResolvableTypeAccessor {
    private final String name;
    private final Class<?> implClass;
    private final ResolvableType resolvableType;
    private final List<Annotation> annotations;

    public ResolvableTypeAccessor(String name, ResolvableType resolvableType, List<Annotation> annotations, Class<?> implClass) {
        this.implClass = implClass;
        this.resolvableType = resolvableType;
        this.annotations = annotations;
        this.name = name;
    }

    public static ResolvableTypeAccessor forClass(Class<?> rawClass) {
        return new ResolvableTypeAccessor(rawClass.getSimpleName(), null, Lists.newArrayList((Object[])rawClass.getAnnotations()), rawClass);
    }

    public static ResolvableTypeAccessor forField(Field field, Class<?> implClass) {
        ResolvableType resolvableType = ResolvableType.forField((Field)field, implClass);
        return new ResolvableTypeAccessor(field.getName(), resolvableType, Lists.newArrayList((Object[])field.getAnnotations()), implClass);
    }

    public static ResolvableTypeAccessor forEnumField(Enum en) {
        Field field = ReflectionUtils.findField(en.getClass(), (String)en.name());
        return new ResolvableTypeAccessor(en.toString(), null, Lists.newArrayList((Object[])field.getAnnotations()), en.getClass());
    }

    public static ResolvableTypeAccessor forMethodReturnType(Method method, Class<?> implClass) {
        ResolvableType resolvableType = ResolvableType.forMethodReturnType((Method)method, implClass);
        return new ResolvableTypeAccessor(method.getName(), resolvableType, Lists.newArrayList((Object[])method.getAnnotations()), implClass);
    }

    public static ResolvableTypeAccessor forMethodParameter(Method method, int argIndex, Class<?> implClass) {
        MethodParameter methodParameter = new MethodParameter(method, argIndex);
        ResolvableType resolvableType = ResolvableType.forMethodParameter((Method)method, (int)argIndex, implClass);
        return new ResolvableTypeAccessor("", resolvableType, Lists.newArrayList((Object[])methodParameter.getParameterAnnotations()), implClass);
    }

    private ResolvableType getResolvableType() {
        return this.resolvableType;
    }

    public Class<?> resolve() {
        return this.getResolvableType().resolve();
    }

    public Type getComponentType() {
        return this.getResolvableType().getComponentType().resolve();
    }

    public boolean isArrayType() {
        Class<?> rawCls = this.resolve();
        return rawCls.isArray() || Iterable.class.equals(rawCls);
    }

    public boolean isCollectionType() {
        Class<?> rawCls = this.resolve();
        return Collection.class.isAssignableFrom(rawCls);
    }

    public boolean isCollectionLike() {
        return this.isArrayType() || this.isCollectionType();
    }

    private <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Annotation foundAnnotation = null;
        for (Annotation itAnnotation : this.annotations) {
            if (!annotationClass.isAssignableFrom(itAnnotation.getClass())) continue;
            foundAnnotation = itAnnotation;
            break;
        }
        return (T)foundAnnotation;
    }

    private <T extends Annotation, V> V getAnnotationValue(Class<T> annotationClass, V fallback) {
        Object result = fallback;
        T annotation = this.getAnnotation(annotationClass);
        if (annotation != null && StringUtils.hasText((String)((String)AnnotationUtils.getValue(annotation)))) {
            result = AnnotationUtils.getValue(annotation);
        }
        return result;
    }

    private <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public Class<?> getImplClass() {
        return this.implClass;
    }

    public boolean isGraphQLIdOrGraphQLField() {
        return this.isGraphQLId() || this.isGraphQLField();
    }

    public boolean isGraphQLField() {
        return this.isAnnotationPresent(GraphQLField.class);
    }

    public boolean isGraphQLId() {
        return this.isAnnotationPresent(GraphQLID.class);
    }

    public boolean isNotNull() {
        return this.isAnnotationPresent(GraphQLNonNull.class);
    }

    public boolean isIgnorable() {
        return this.isAnnotationPresent(GraphQLIgnore.class);
    }

    public boolean isNotIgnorable() {
        return !this.isIgnorable();
    }

    public boolean isGraphQLInterface() {
        return this.implClass.isInterface() && this.isAnnotationPresent(GraphQLInterface.class);
    }

    public boolean isGraphQLUnion() {
        return this.implClass.isInterface() && this.isAnnotationPresent(GraphQLUnion.class);
    }

    public Class<?>[] getGraphQLUnionPossibleTypes() {
        GraphQLUnion graphQLUnion = this.getAnnotation(GraphQLUnion.class);
        return graphQLUnion != null ? graphQLUnion.possibleTypes() : new Class[]{};
    }

    public String getName() {
        String result = this.getAnnotationValue(GraphQLField.class, this.name);
        result = this.getAnnotationValue(GraphQLID.class, result);
        result = this.getAnnotationValue(GraphQLMutation.class, result);
        result = this.getAnnotationValue(GraphQLObject.class, result);
        result = this.getAnnotationValue(GraphQLInterface.class, result);
        result = this.getAnnotationValue(GraphQLUnion.class, result);
        result = this.getAnnotationValue(GraphQLEnum.class, result);
        return result;
    }

    public String getGraphQLOutName() {
        String result = this.getAnnotationValue(GraphQLOut.class, this.name);
        return result;
    }

    public String getGraphQLInName() {
        String result = this.getAnnotationValue(GraphQLIn.class, "");
        return result;
    }

    public String getGraphQLDeprecationReason() {
        String result = this.getAnnotationValue(GraphQLDeprecate.class, null);
        return result;
    }

    public String getGraphQLComplexitySpelExpression() {
        String result = this.getAnnotationValue(GraphQLComplexity.class, null);
        return result;
    }

    public boolean hasGraphQLComplexity() {
        return StringUtils.hasText((String)this.getGraphQLComplexitySpelExpression());
    }

    public boolean hasGraphQLDeprecationReason() {
        return StringUtils.hasText((String)this.getGraphQLDeprecationReason());
    }

    public boolean isGraphQLInParameter() {
        return StringUtils.hasText((String)this.getGraphQLInName());
    }

    public boolean isRequiredGraphQLInParameter() {
        GraphQLIn graphQLIn = this.getAnnotation(GraphQLIn.class);
        boolean isRequired = false;
        if (graphQLIn != null) {
            isRequired = graphQLIn.required();
        }
        return isRequired;
    }

    public String getGraphQLInDefaultValueProviderMethodName() {
        GraphQLIn graphQLIn = this.getAnnotation(GraphQLIn.class);
        String defaultValueProviderMethod = "";
        if (graphQLIn != null) {
            defaultValueProviderMethod = graphQLIn.defaultProvider();
        }
        return defaultValueProviderMethod;
    }

    public String getGraphQLEnumValueProviderMethodName() {
        GraphQLEnum graphQLIn = this.getAnnotation(GraphQLEnum.class);
        String defaultValueProviderMethod = "";
        if (graphQLIn != null) {
            defaultValueProviderMethod = graphQLIn.valueProvider();
        }
        return defaultValueProviderMethod;
    }

    public String getGraphQLInDefaultValueSpel() {
        GraphQLIn graphQLIn = this.getAnnotation(GraphQLIn.class);
        String GraphQLInValueSpel = "";
        if (graphQLIn != null) {
            GraphQLInValueSpel = graphQLIn.defaultSpel();
        }
        return GraphQLInValueSpel;
    }

    public String getGraphQLEnumDefaultValueSpel() {
        GraphQLEnum graphQLIn = this.getAnnotation(GraphQLEnum.class);
        String defaultValueSpel = "";
        if (graphQLIn != null) {
            defaultValueSpel = graphQLIn.defaultSpel();
        }
        return defaultValueSpel;
    }

    public boolean isGraphQLMutation() {
        return this.isAnnotationPresent(GraphQLMutation.class);
    }

    public String getDescription() {
        return this.getAnnotationValue(GraphQLDescription.class, this.name);
    }

    public Class<?> getActualType() {
        Class type = this.resolve();
        if (this.isArrayType()) {
            type = (Class)this.getComponentType();
        }
        if (this.isCollectionType()) {
            type = this.resolvableType.getGeneric(new int[]{0}).resolve();
        }
        return type;
    }
}

