/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.execute;

import com.oembedler.moon.graphql.engine.GraphQLSchemaHolder;
import com.oembedler.moon.graphql.engine.dfs.GraphQLFieldDefinitionWrapper;
import com.oembedler.moon.graphql.engine.execute.GraphQLExecutionContext;
import com.oembedler.moon.graphql.engine.execute.GraphQLRxExecutionResult;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategy;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.core.NestedRuntimeException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import rx.Observable;
import rx.observables.MathObservable;

abstract class GraphQLAbstractRxExecutionStrategy
extends ExecutionStrategy {
    public static final Double NODE_SCORE = 1.0;
    protected final GraphQLSchemaHolder graphQLSchemaHolder;
    protected final int maxQueryDepth;
    protected final int maxQueryComplexity;

    public GraphQLAbstractRxExecutionStrategy(GraphQLSchemaHolder graphQLSchemaHolder, int maxQueryDepth, int maxQueryComplexity) {
        this.graphQLSchemaHolder = graphQLSchemaHolder;
        this.maxQueryDepth = maxQueryDepth;
        this.maxQueryComplexity = maxQueryComplexity;
    }

    public ExecutionResult execute(ExecutionContext executionContext, GraphQLObjectType parentType, Object source, Map<String, List<Field>> fields) {
        GraphQLExecutionContext graphQLExecutionContext = this.wrapIfAny(executionContext);
        if (this.isCurrentDepthLimitExceeded(graphQLExecutionContext)) {
            return null;
        }
        ExecutionResult executionResult = this.doExecute(this.updateContext(graphQLExecutionContext), parentType, source, fields);
        return executionResult;
    }

    public abstract ExecutionResult doExecute(ExecutionContext var1, GraphQLObjectType var2, Object var3, Map<String, List<Field>> var4);

    protected GraphQLExecutionContext wrapIfAny(ExecutionContext executionContext) {
        if (executionContext instanceof GraphQLExecutionContext) {
            return (GraphQLExecutionContext)executionContext;
        }
        int currentDepth = executionContext.getOperationDefinition().getOperation() == OperationDefinition.Operation.MUTATION ? 1 : 0;
        return new GraphQLExecutionContext(executionContext, currentDepth);
    }

    protected GraphQLExecutionContext updateContext(GraphQLExecutionContext currentExecutionContext) {
        return new GraphQLExecutionContext(currentExecutionContext.getDelegate(), currentExecutionContext.getCurrentDepth() + 1);
    }

    protected boolean isCurrentDepthLimitExceeded(GraphQLExecutionContext executionContext) {
        int currentDepth = executionContext.getCurrentDepth();
        return this.maxQueryDepth > 0 && currentDepth > this.maxQueryDepth;
    }

    protected Observable<Double> calculateFieldComplexity(ExecutionContext executionContext, GraphQLObjectType parentType, List<Field> fields, Observable<Double> childScore) {
        return childScore.flatMap(aDouble -> {
            Expression expression;
            GraphQLFieldDefinitionWrapper graphQLFieldDefinitionWrapper;
            Observable result = Observable.just((Object)(aDouble + NODE_SCORE));
            GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, (Field)fields.get(0));
            if (fieldDef != null && (graphQLFieldDefinitionWrapper = this.getGraphQLFieldDefinitionWrapper(fieldDef)) != null && (expression = graphQLFieldDefinitionWrapper.getComplexitySpelExpression()) != null) {
                Map argumentValues = this.valuesResolver.getArgumentValues(fieldDef.getArguments(), ((Field)fields.get(0)).getArguments(), executionContext.getVariables());
                StandardEvaluationContext context = new StandardEvaluationContext();
                context.setVariable("childScore", aDouble);
                if (argumentValues != null) {
                    context.setVariables(argumentValues);
                }
                result = Observable.just((Object)expression.getValue((EvaluationContext)context, Double.class));
            }
            return this.addComplexityCheckObservable(executionContext, (Observable<Double>)result);
        });
    }

    protected GraphQLFieldDefinitionWrapper getGraphQLFieldDefinitionWrapper(GraphQLFieldDefinition fieldDef) {
        return this.graphQLSchemaHolder.getFieldDefinitionResolverMap().get(fieldDef);
    }

    protected Observable<Double> addComplexityCheckObservable(ExecutionContext executionContext, Observable<Double> fieldComplexity) {
        if (executionContext instanceof GraphQLExecutionContext) {
            return fieldComplexity.flatMap(complexity -> {
                if (this.maxQueryComplexity > 0 && complexity > (double)this.maxQueryComplexity) {
                    throw new QueryComplexityLimitExceededRuntimeException("Query complexity limit exceeded. Current [" + complexity + "]. Limit [" + this.maxQueryComplexity + "]");
                }
                return Observable.just((Object)complexity);
            });
        }
        return fieldComplexity;
    }

    protected ExecutionResult completeValue(ExecutionContext executionContext, GraphQLType fieldType, List<Field> fields, Object result) {
        if (result instanceof Observable) {
            return new GraphQLRxExecutionResult(((Observable)result).map(r -> super.completeValue(executionContext, fieldType, fields, r)), null);
        }
        return super.completeValue(executionContext, fieldType, fields, result);
    }

    protected ExecutionResult completeValueForEnum(GraphQLEnumType enumType, Object result) {
        return new GraphQLRxExecutionResult(Observable.just((Object)enumType.getCoercing().serialize(result)), (Observable<List<? extends GraphQLError>>)Observable.just(null), (Observable<Double>)Observable.just((Object)0.0));
    }

    protected ExecutionResult completeValueForScalar(GraphQLScalarType scalarType, Object result) {
        return new GraphQLRxExecutionResult(Observable.just((Object)scalarType.getCoercing().serialize(result)), (Observable<List<? extends GraphQLError>>)Observable.just(null), (Observable<Double>)Observable.just((Object)0.0));
    }

    protected ExecutionResult completeValueForList(ExecutionContext executionContext, GraphQLList fieldType, List<Field> fields, List<Object> result) {
        Observable cachedObservable = Observable.from((Object[])IntStream.range(0, result.size()).mapToObj(idx -> new ListTuple(idx, result.get(idx), null)).toArray(ListTuple[]::new)).flatMap(tuple -> {
            ExecutionResult executionResult = this.completeValue(executionContext, fieldType.getWrappedType(), fields, tuple.result);
            if (executionResult instanceof GraphQLRxExecutionResult) {
                return Observable.zip((Observable)Observable.just((Object)tuple.index), ((GraphQLRxExecutionResult)executionResult).getDataObservable(), ((GraphQLRxExecutionResult)executionResult).getComplexityObservable(), (arg_0, arg_1, arg_2) -> ListTuple.new(this, arg_0, arg_1, arg_2));
            }
            return Observable.just((Object)new ListTuple(tuple.index, executionResult.getData(), Observable.just((Object)1.0)));
        }).toList().cache();
        Observable resultObservable = cachedObservable.map(listTuples -> listTuples.stream().sorted(Comparator.comparingInt(x -> x.index)).map(x -> x.result).collect(Collectors.toList()));
        Observable complexityObservable = cachedObservable.map(listTuples -> listTuples.stream().sorted(Comparator.comparingInt(x -> x.index)).map(x -> x.complexity).collect(Collectors.toList())).flatMap(combined -> Observable.from((Iterable)combined));
        return new GraphQLRxExecutionResult(resultObservable, null, (Observable<Double>)MathObservable.sumDouble((Observable)complexityObservable));
    }

    public static class QueryComplexityLimitExceededRuntimeException
    extends NestedRuntimeException {
        public QueryComplexityLimitExceededRuntimeException(String msg) {
            super(msg);
        }
    }

    private class ListTuple {
        public int index;
        public Object result;
        public Object complexity;

        public ListTuple(int index, Object result, Object complexity) {
            this.index = index;
            this.result = result;
            this.complexity = complexity;
        }
    }
}

