/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.execute;

import com.oembedler.moon.graphql.engine.GraphQLSchemaHolder;
import com.oembedler.moon.graphql.engine.execute.GraphQLAbstractRxExecutionStrategy;
import com.oembedler.moon.graphql.engine.execute.GraphQLRxExecutionResult;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.execution.ExecutionContext;
import graphql.language.Field;
import graphql.schema.GraphQLObjectType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import rx.Observable;
import rx.observables.MathObservable;

class GraphQLDefaultRxExecutionStrategy
extends GraphQLAbstractRxExecutionStrategy {
    public GraphQLDefaultRxExecutionStrategy(GraphQLSchemaHolder graphQLSchemaHolder, int maxQueryDepth, int maxQueryComplexity) {
        super(graphQLSchemaHolder, maxQueryDepth, maxQueryComplexity);
    }

    @Override
    public ExecutionResult doExecute(ExecutionContext executionContext, GraphQLObjectType parentType, Object source, Map<String, List<Field>> fields) {
        ArrayList<Observable<Pair<String, Object>>> observablesResult = new ArrayList<Observable<Pair<String, Object>>>();
        ArrayList<Observable<Double>> observablesComplexity = new ArrayList<Observable<Double>>();
        for (String fieldName : fields.keySet()) {
            List<Field> fieldList = fields.get(fieldName);
            ExecutionResult executionResult = this.resolveField(executionContext, parentType, source, fieldList);
            observablesResult.add(this.unwrapExecutionResult(fieldName, executionResult));
            observablesComplexity.add(this.calculateFieldComplexity(executionContext, parentType, fieldList, (Observable<Double>)(executionResult != null ? ((GraphQLRxExecutionResult)executionResult).getComplexityObservable() : Observable.just((Object)0.0))));
        }
        Observable result = Observable.merge(observablesResult).toMap(Pair::getLeft, Pair::getRight);
        GraphQLRxExecutionResult graphQLRxExecutionResult = new GraphQLRxExecutionResult(result, (Observable<List<? extends GraphQLError>>)Observable.just((Object)executionContext.getErrors()), (Observable<Double>)MathObservable.sumDouble((Observable)Observable.merge(observablesComplexity)));
        return graphQLRxExecutionResult;
    }

    protected Observable<Pair<String, Object>> unwrapExecutionResult(String fieldName, ExecutionResult executionResult) {
        Observable result;
        if (executionResult instanceof GraphQLRxExecutionResult) {
            GraphQLRxExecutionResult rxResult = (GraphQLRxExecutionResult)executionResult;
            Observable unwrappedResult = rxResult.getDataObservable().flatMap(potentialResult -> {
                if (potentialResult instanceof GraphQLRxExecutionResult) {
                    return ((GraphQLRxExecutionResult)potentialResult).getDataObservable();
                }
                return Observable.just((Object)potentialResult);
            });
            result = Observable.zip((Observable)Observable.just((Object)fieldName), (Observable)unwrappedResult, Pair::of);
        } else {
            result = Observable.just((Object)Pair.of((Object)fieldName, (Object)(executionResult != null ? executionResult.getData() : null)));
        }
        return result;
    }
}

