/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.execute;

import com.oembedler.moon.graphql.engine.GraphQLSchemaHolder;
import com.oembedler.moon.graphql.engine.execute.GraphQLDefaultRxExecutionStrategy;
import com.oembedler.moon.graphql.engine.execute.GraphQLRxExecutionResult;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.execution.ExecutionContext;
import graphql.language.Field;
import graphql.schema.GraphQLObjectType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RecursiveTask;
import org.apache.commons.lang3.tuple.Pair;
import rx.Observable;
import rx.observables.MathObservable;

class GraphQLExecutorServiceRxExecutionStrategy
extends GraphQLDefaultRxExecutionStrategy {
    private final ExecutorService executorService;

    public GraphQLExecutorServiceRxExecutionStrategy(GraphQLSchemaHolder graphQLSchemaHolder, ExecutorService executorService, int maxQueryDepth, int maxQueryComplexity) {
        super(graphQLSchemaHolder, maxQueryDepth, maxQueryComplexity);
        this.executorService = executorService;
    }

    @Override
    public ExecutionResult doExecute(final ExecutionContext executionContext, final GraphQLObjectType parentType, final Object source, Map<String, List<Field>> fields) {
        LinkedHashMap<String, 1> recursiveTaskMap = new LinkedHashMap<String, 1>();
        for (String fieldName : fields.keySet()) {
            final List<Field> fieldList = fields.get(fieldName);
            RecursiveTask<ExecutionResult> resolveField = new RecursiveTask<ExecutionResult>(){

                @Override
                protected ExecutionResult compute() {
                    return GraphQLExecutorServiceRxExecutionStrategy.this.resolveField(executionContext, parentType, source, fieldList);
                }
            };
            resolveField.fork();
            recursiveTaskMap.put(fieldName, resolveField);
        }
        ArrayList<Observable<Pair<String, Object>>> observablesResult = new ArrayList<Observable<Pair<String, Object>>>();
        ArrayList<Observable<Double>> observablesComplexity = new ArrayList<Observable<Double>>();
        for (String fieldName : recursiveTaskMap.keySet()) {
            List<Field> fieldList = fields.get(fieldName);
            ExecutionResult executionResult = (ExecutionResult)((RecursiveTask)recursiveTaskMap.get(fieldName)).join();
            observablesResult.add(this.unwrapExecutionResult(fieldName, executionResult));
            observablesComplexity.add(this.calculateFieldComplexity(executionContext, parentType, fieldList, (Observable<Double>)(executionResult != null ? ((GraphQLRxExecutionResult)executionResult).getComplexityObservable() : Observable.just((Object)0.0))));
        }
        Observable result = Observable.merge(observablesResult).toMap(Pair::getLeft, Pair::getRight);
        GraphQLRxExecutionResult graphQLRxExecutionResult = new GraphQLRxExecutionResult(result, (Observable<List<? extends GraphQLError>>)Observable.just((Object)executionContext.getErrors()), (Observable<Double>)MathObservable.sumDouble((Observable)Observable.merge(observablesComplexity)));
        return graphQLRxExecutionResult;
    }
}

