/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.execute;

import com.oembedler.moon.graphql.engine.GraphQLSchemaHolder;
import com.oembedler.moon.graphql.engine.execute.GraphQLDefaultRxExecutionStrategy;
import com.oembedler.moon.graphql.engine.execute.GraphQLExecutorServiceRxExecutionStrategy;
import com.oembedler.moon.graphql.engine.execute.GraphQLRxExecutionResult;
import com.oembedler.moon.graphql.engine.execute.RxExecution;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.execution.ExecutionStrategy;
import graphql.language.Document;
import graphql.language.SourceLocation;
import graphql.parser.Parser;
import graphql.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import rx.Observable;

public class GraphQLQueryExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLQueryExecutor.class);
    private GraphQLSchemaHolder graphQLSchemaHolder;
    private ExecutionStrategy executionStrategy;
    private String requestQuery;
    private String operationName;
    private Object context = Collections.emptyMap();
    private Map<String, Object> arguments = Collections.emptyMap();
    private ExecutorService executorService;
    private int maxQueryComplexity = -1;
    private int maxQueryDepth = -1;

    private GraphQLQueryExecutor(GraphQLSchemaHolder graphQLSchemaHolder) {
        this(graphQLSchemaHolder, null);
    }

    private GraphQLQueryExecutor(GraphQLSchemaHolder graphQLSchemaHolder, ExecutionStrategy executionStrategy) {
        Assert.notNull((Object)graphQLSchemaHolder, (String)"GraphQL Schema holder can not be null");
        this.graphQLSchemaHolder = graphQLSchemaHolder;
        this.executionStrategy = executionStrategy;
    }

    public static GraphQLQueryExecutor create(GraphQLSchemaHolder graphQLSchemaHolder) {
        return new GraphQLQueryExecutor(graphQLSchemaHolder);
    }

    public static GraphQLQueryExecutor create(GraphQLSchemaHolder graphQLSchemaHolder, ExecutionStrategy executionStrategy) {
        return new GraphQLQueryExecutor(graphQLSchemaHolder, executionStrategy);
    }

    public GraphQLQueryExecutor query(String requestQuery) {
        this.requestQuery = requestQuery;
        return this;
    }

    public GraphQLQueryExecutor operation(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public GraphQLQueryExecutor context(Object context) {
        this.context = context;
        return this;
    }

    public GraphQLQueryExecutor arguments(Map<String, Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public GraphQLQueryExecutor maxQueryComplexity(int maxQueryComplexity) {
        this.maxQueryComplexity = maxQueryComplexity;
        return this;
    }

    public GraphQLQueryExecutor maxQueryDepth(int maxQueryDepth) {
        this.maxQueryDepth = maxQueryDepth;
        return this;
    }

    public GraphQLQueryExecutor executorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public GraphQLQueryExecutor forkJoinExecutorService(int parallelism) {
        this.executorService = Executors.newWorkStealingPool(parallelism);
        return this;
    }

    public GraphQLQueryExecutor forkJoinExecutorService() {
        this.executorService = Executors.newWorkStealingPool();
        return this;
    }

    public <T extends ExecutionResult> T execute() {
        RxExecution execution;
        ExecutionResult executionResult;
        Document document;
        graphql.Assert.assertNotNull(this.arguments, (String)"Arguments can't be null");
        LOGGER.info("Executing request. Operation name: {}. Request: {} ", (Object)this.operationName, (Object)this.requestQuery);
        Parser parser = new Parser();
        try {
            document = parser.parseDocument(this.requestQuery);
        }
        catch (ParseCancellationException e) {
            RecognitionException recognitionException = (RecognitionException)e.getCause();
            SourceLocation sourceLocation = new SourceLocation(recognitionException.getOffendingToken().getLine(), recognitionException.getOffendingToken().getCharPositionInLine());
            InvalidSyntaxError invalidSyntaxError = new InvalidSyntaxError(sourceLocation);
            return (T)new GraphQLRxExecutionResult(Observable.just(null), (Observable<List<? extends GraphQLError>>)Observable.just(Arrays.asList(invalidSyntaxError)));
        }
        Validator validator = new Validator();
        List validationErrors = validator.validateDocument(this.graphQLSchemaHolder.getGraphQLSchema(), document);
        if (validationErrors.size() > 0) {
            return (T)new GraphQLRxExecutionResult(Observable.just(null), (Observable<List<? extends GraphQLError>>)Observable.just((Object)validationErrors));
        }
        if (this.executionStrategy == null) {
            this.executionStrategy = this.executorService == null ? new GraphQLDefaultRxExecutionStrategy(this.graphQLSchemaHolder, this.maxQueryDepth, this.maxQueryComplexity) : new GraphQLExecutorServiceRxExecutionStrategy(this.graphQLSchemaHolder, this.executorService, this.maxQueryDepth, this.maxQueryComplexity);
        }
        return (T)((executionResult = (execution = new RxExecution(this.graphQLSchemaHolder, this.maxQueryDepth, this.maxQueryComplexity, this.executionStrategy)).execute(this.graphQLSchemaHolder.getGraphQLSchema(), this.context, document, this.operationName, this.arguments)) instanceof GraphQLRxExecutionResult ? executionResult : new GraphQLRxExecutionResult(Observable.just((Object)executionResult.getData()), (Observable<List<? extends GraphQLError>>)Observable.just((Object)executionResult.getErrors())));
    }
}

