/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.type;

import graphql.GraphQLException;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.util.Assert;

public class GraphQLDateType
extends GraphQLScalarType {
    public GraphQLDateType(String name, String description, final String dateFormat) {
        super(name, description, new Coercing(){
            private final TimeZone timeZone = TimeZone.getTimeZone("UTC");

            public Object serialize(Object input) {
                if (input instanceof String) {
                    return this.parse((String)input);
                }
                if (input instanceof Date) {
                    return this.format((Date)input);
                }
                if (input instanceof Long) {
                    return new Date((Long)input);
                }
                if (input instanceof Integer) {
                    return new Date(((Integer)input).longValue());
                }
                throw new GraphQLException("Wrong timestamp value");
            }

            public Object parseValue(Object input) {
                return this.serialize(input);
            }

            public Object parseLiteral(Object input) {
                if (!(input instanceof StringValue)) {
                    return null;
                }
                return this.parse(((StringValue)input).getValue());
            }

            private String format(Date input) {
                return this.getSimpleDateFormat().format(input.getTime());
            }

            private Date parse(String input) {
                Date date = null;
                try {
                    date = this.getSimpleDateFormat().parse(input);
                }
                catch (Exception e) {
                    throw new GraphQLException("Can not parse input date", (Throwable)e);
                }
                return date;
            }

            private SimpleDateFormat getSimpleDateFormat() {
                SimpleDateFormat df = new SimpleDateFormat(dateFormat);
                df.setTimeZone(this.timeZone);
                return df;
            }
        });
        Assert.notNull((Object)dateFormat, (String)"Date format must not be null");
    }
}

