/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.type;

import graphql.GraphQLException;
import graphql.schema.Coercing;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import java.util.ArrayList;
import java.util.List;

public class GraphQLEnumTypeExt
extends GraphQLEnumType {
    private final Coercing coercingExt = new Coercing(){

        public Object serialize(Object input) {
            return GraphQLEnumTypeExt.this.getNameByValue(input);
        }

        public Object parseValue(Object input) {
            return GraphQLEnumTypeExt.this.getCoercingSuper().parseValue(input);
        }

        public Object parseLiteral(Object input) {
            return GraphQLEnumTypeExt.this.getCoercingSuper().parseLiteral(input);
        }
    };

    public GraphQLEnumTypeExt(String name, String description, List<GraphQLEnumValueDefinition> values) {
        super(name, description, values);
    }

    private Object getNameByValue(Object value) {
        Object normalizedValue = this.enumToStringIfAny(value);
        for (GraphQLEnumValueDefinition valueDefinition : this.getValues()) {
            if (!normalizedValue.equals(valueDefinition.getValue())) continue;
            return valueDefinition.getName();
        }
        throw new GraphQLException("");
    }

    private Object enumToStringIfAny(Object value) {
        if (value instanceof Enum) {
            return value.toString();
        }
        return value;
    }

    public Coercing getCoercing() {
        return this.coercingExt;
    }

    public Coercing getCoercingSuper() {
        return super.getCoercing();
    }

    public static class Builder {
        private String name;
        private String description;
        private final List<GraphQLEnumValueDefinition> values = new ArrayList<GraphQLEnumValueDefinition>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder value(String name, Object value, String description) {
            this.values.add(new GraphQLEnumValueDefinition(name, description, value));
            return this;
        }

        public Builder value(String name, Object value) {
            this.values.add(new GraphQLEnumValueDefinition(name, null, value));
            return this;
        }

        public Builder value(String name) {
            this.values.add(new GraphQLEnumValueDefinition(name, null, (Object)name));
            return this;
        }

        public GraphQLEnumType build() {
            return new GraphQLEnumTypeExt(this.name, this.description, this.values);
        }
    }
}

