/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.engine.type;

import graphql.GraphQLException;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import org.springframework.util.Assert;

public class GraphQLLocalDateTimeType
extends GraphQLScalarType {
    public GraphQLLocalDateTimeType(String name, String description, final String dateFormat) {
        super(name, description, new Coercing(){
            private final TimeZone timeZone = TimeZone.getTimeZone("UTC");

            public Object serialize(Object input) {
                if (input instanceof String) {
                    return this.parse((String)input);
                }
                if (input instanceof LocalDateTime) {
                    return this.format((LocalDateTime)input);
                }
                if (input instanceof Long) {
                    return LocalDateTime.ofEpochSecond((Long)input, 0, ZoneOffset.UTC);
                }
                if (input instanceof Integer) {
                    return LocalDateTime.ofEpochSecond(((Integer)input).longValue(), 0, ZoneOffset.UTC);
                }
                throw new GraphQLException("Wrong timestamp value");
            }

            public Object parseValue(Object input) {
                return this.serialize(input);
            }

            public Object parseLiteral(Object input) {
                if (!(input instanceof StringValue)) {
                    return null;
                }
                return this.parse(((StringValue)input).getValue());
            }

            private String format(LocalDateTime input) {
                return this.getDateTimeFormatter().format(input);
            }

            private LocalDateTime parse(String input) {
                LocalDateTime date = null;
                try {
                    date = LocalDateTime.parse(input, this.getDateTimeFormatter());
                }
                catch (Exception e) {
                    throw new GraphQLException("Can not parse input date", (Throwable)e);
                }
                return date;
            }

            private DateTimeFormatter getDateTimeFormatter() {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
                return formatter;
            }
        });
        Assert.notNull((Object)dateFormat, (String)"Date format must not be null");
    }
}

