/*
 * Decompiled with CFR 0.152.
 */
package com.emc.acdp.api.jersey;

import com.emc.acdp.AcdpException;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class ErrorFilter
extends ClientFilter {
    private static final Logger log = Logger.getLogger(ErrorFilter.class);

    public ClientResponse handle(ClientRequest clientRequest) throws ClientHandlerException {
        ClientResponse response = this.getNext().handle(clientRequest);
        if (response.getStatus() > 299) {
            String message;
            Document d;
            SAXBuilder sb = new SAXBuilder();
            try {
                d = sb.build(response.getEntityInputStream());
            }
            catch (Exception e) {
                throw new AcdpException(response.getStatusInfo().getReasonPhrase(), response.getStatus());
            }
            String code = d.getRootElement().getChildText("code");
            if (code == null) {
                code = d.getRootElement().getChildText("code", Namespace.getNamespace((String)"http://cdp.emc.com/services/rest/model"));
            }
            if ((message = d.getRootElement().getChildText("message")) == null) {
                message = d.getRootElement().getChildText("message", Namespace.getNamespace((String)"http://cdp.emc.com/services/rest/model"));
            }
            if (code == null && message == null) {
                throw new AcdpException(response.getStatusInfo().getReasonPhrase(), response.getStatus());
            }
            log.debug((Object)("Error: " + code + " message: " + message));
            throw new AcdpException(message, response.getStatus(), code);
        }
        return response;
    }
}

