/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.jersey;

import com.emc.atmos.AtmosException;
import com.emc.atmos.api.AtmosConfig;
import com.emc.atmos.api.jersey.ConfigProxySelector;
import com.emc.atmos.api.jersey.JerseyUtil;
import com.emc.util.SslUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import java.net.ProxySelector;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import sun.net.spi.DefaultProxySelector;

public class JerseyApacheUtil {
    private static Pattern BOOLEAN_PATTERN = Pattern.compile("([tT][rR][uU][eE]|[fF][aA][lL][sS][eE])");
    private static Pattern DOUBLE_PATTERN = Pattern.compile("[0-9]*\\.[0-9]+");
    private static Pattern INT_PATTERN = Pattern.compile("[0-9]+");
    private static Set<String> LONG_PARAMETERS = new TreeSet<String>(Collections.singletonList("http.conn-manager.timeout"));

    public static Client createApacheClient(AtmosConfig config, boolean useExpect100Continue, List<Class<MessageBodyReader<?>>> readers, List<Class<MessageBodyWriter<?>>> writers) {
        try {
            ProxySelector proxySelector;
            URI proxyUri;
            DefaultApacheHttpClient4Config clientConfig = new DefaultApacheHttpClient4Config();
            PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
            connectionManager.setMaxTotal(200);
            connectionManager.setDefaultMaxPerRoute(200);
            clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", connectionManager);
            if (config.isDisableSslValidation()) {
                connectionManager.getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(SslUtil.createGullibleSslContext(), SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER)));
            }
            if ((proxyUri = config.getProxyUri()) != null) {
                proxySelector = new ConfigProxySelector(config);
            } else {
                int port;
                proxySelector = new DefaultProxySelector();
                String host = System.getProperty("http.proxyHost");
                String portStr = System.getProperty("http.proxyPort");
                int n = port = portStr != null ? Integer.parseInt(portStr) : -1;
                if (host != null && host.length() > 0) {
                    proxyUri = new URI("http", null, host, port, null, null, null);
                }
            }
            if (proxyUri != null) {
                clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", proxyUri);
            }
            String proxyUser = config.getProxyUser();
            String proxyPassword = config.getProxyPassword();
            if (proxyUser == null) {
                proxyUser = System.getProperty("http.proxyUser");
                proxyPassword = System.getProperty("http.proxyPassword");
            }
            if (proxyUser != null && proxyUser.length() > 0) {
                clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", proxyUser);
                clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", proxyPassword);
            }
            SyncBasicHttpParams httpParams = new SyncBasicHttpParams();
            DefaultHttpClient.setDefaultHttpParams((HttpParams)httpParams);
            httpParams.setBooleanParameter("http.protocol.expect-continue", useExpect100Continue);
            clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.httpParams", httpParams);
            for (String prop : System.getProperties().stringPropertyNames()) {
                if (!prop.startsWith("http.")) continue;
                String value = System.getProperty(prop);
                if (LONG_PARAMETERS.contains(prop)) {
                    httpParams.setLongParameter(prop, Long.parseLong(value.substring(0, value.length() - 1)));
                    continue;
                }
                if (BOOLEAN_PATTERN.matcher(value).matches()) {
                    httpParams.setBooleanParameter(prop, Boolean.parseBoolean(value));
                    continue;
                }
                if (DOUBLE_PATTERN.matcher(value).matches()) {
                    httpParams.setDoubleParameter(prop, Double.parseDouble(value));
                    continue;
                }
                if (INT_PATTERN.matcher(value).matches()) {
                    httpParams.setIntParameter(prop, Integer.parseInt(value));
                    continue;
                }
                httpParams.setParameter(prop, (Object)System.getProperty(prop));
            }
            JerseyUtil.addHandlers((ClientConfig)clientConfig, readers, writers);
            ApacheHttpClient4 client = ApacheHttpClient4.create((ClientConfig)clientConfig);
            AbstractHttpClient httpClient = (AbstractHttpClient)client.getClientHandler().getHttpClient();
            httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
            SchemeRegistry registry = httpClient.getConnectionManager().getSchemeRegistry();
            httpClient.setRoutePlanner((HttpRoutePlanner)new ProxySelectorRoutePlanner(registry, proxySelector));
            JerseyUtil.addFilters((Client)client, config);
            return client;
        }
        catch (Exception e) {
            throw new AtmosException("Error configuring REST client", e);
        }
    }
}

