/*
 * Decompiled with CFR 0.152.
 */
package com.emc.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class StreamUtil {
    public static String readAsString(InputStream in) throws IOException {
        try {
            String string = new Scanner(in, "UTF-8").useDelimiter("\\A").next();
            return string;
        }
        catch (NoSuchElementException e) {
            String string = "";
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAsBytes(InputStream in) throws IOException {
        try {
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int c = 0;
            while ((c = in.read(buffer)) != -1) {
                baos.write(buffer, 0, c);
            }
            baos.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String readLine(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c = in.read();
        if (c == -1 || c == 10) {
            return "";
        }
        int c2 = in.read();
        while (c2 != -1 && (char)c2 != '\n') {
            baos.write(c);
            c = c2;
            c2 = in.read();
        }
        if ((char)c != '\r') {
            baos.write(c);
        }
        return new String(baos.toByteArray(), "UTF-8");
    }

    public static long copy(InputStream is, OutputStream os, long maxBytes) throws IOException {
        int maxRead;
        long count;
        byte[] buffer = new byte[65536];
        int read = 0;
        for (count = 0L; count < maxBytes && -1 != (read = is.read(buffer, 0, maxRead = (int)Math.min((long)buffer.length, maxBytes - count))); count += (long)read) {
            os.write(buffer, 0, read);
        }
        return count;
    }

    private StreamUtil() {
    }
}

