/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos;

import com.emc.atmos.LoadBalancingAlgorithm;
import com.emc.atmos.RoundRobinAlgorithm;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractConfig {
    private static final Logger l4j = LoggerFactory.getLogger(AbstractConfig.class);
    private String context;
    private URI[] endpoints;
    private boolean disableSslValidation = false;
    private LoadBalancingAlgorithm loadBalancingAlgorithm = new RoundRobinAlgorithm();

    public AbstractConfig(String context, URI ... endpoints) {
        this.context = context;
        this.endpoints = endpoints;
    }

    public URI resolvePath(String relativePath, String query) {
        return this.resolveHostAndPath(relativePath, query);
    }

    public URI resolveHostAndPath(String relativePath, String query) {
        String path = relativePath;
        if (path.length() == 0 || path.charAt(0) != '/') {
            path = '/' + path;
        }
        if (!path.startsWith(this.context)) {
            path = this.context + path;
        }
        path = path.replaceAll("//", "/");
        return this.resolveHost(path, query);
    }

    public URI resolveHost(String absolutePath, String query) {
        URI endpoint = this.loadBalancingAlgorithm.getNextEndpoint(this.endpoints);
        try {
            URI uri = new URI(endpoint.getScheme(), null, endpoint.getHost(), endpoint.getPort(), absolutePath, query, null);
            l4j.debug("raw path & query: " + absolutePath + "?" + query);
            l4j.debug("encoded URI: " + uri);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URI syntax", e);
        }
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isDisableSslValidation() {
        return this.disableSslValidation;
    }

    public void setDisableSslValidation(boolean disableSslValidation) {
        this.disableSslValidation = disableSslValidation;
    }

    public URI[] getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(URI[] endpoints) {
        this.endpoints = endpoints;
    }

    public LoadBalancingAlgorithm getLoadBalancingAlgorithm() {
        return this.loadBalancingAlgorithm;
    }

    public void setLoadBalancingAlgorithm(LoadBalancingAlgorithm loadBalancingAlgorithm) {
        this.loadBalancingAlgorithm = loadBalancingAlgorithm;
    }
}

