/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsRequestBase;
import com.emc.ecs.nfsclient.nfs.NfsSetAttributes;
import com.emc.ecs.nfsclient.nfs.NfsType;
import com.emc.ecs.nfsclient.rpc.Credential;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.io.FileNotFoundException;

public class NfsMknodRequest
extends NfsRequestBase {
    private final String _name;
    private final NfsType _type;
    private final NfsSetAttributes _attributes;
    private final long[] _rdev;

    public NfsMknodRequest(byte[] fileHandle, String name, NfsType type, NfsSetAttributes attributes, long[] rdev, Credential credential, int nfsVersion) throws FileNotFoundException {
        super(100003, nfsVersion, 10, credential, fileHandle);
        this._name = NfsMknodRequest.trimFileName(name);
        this._type = type;
        this._attributes = attributes;
        this._rdev = rdev == null ? null : (long[])rdev.clone();
    }

    @Override
    public void marshalling(Xdr xdr) {
        super.marshalling(xdr);
        xdr.putString(this._name);
        xdr.putUnsignedInt(this._type.getValue());
        if (this._type == NfsType.NFS_BLK || this._type == NfsType.NFS_CHR) {
            this._attributes.marshalling(xdr);
            xdr.putUnsignedInt(this._rdev[0]);
            xdr.putUnsignedInt(this._rdev[1]);
        } else if (this._type == NfsType.NFS_SOCK || this._type == NfsType.NFS_FIFO) {
            this._attributes.marshalling(xdr);
        }
    }

    public String toString() {
        return this.startToString("NfsMknodRequest").append(" name:").append(this._name).append(" attributes:").append(this._attributes.toString()).toString();
    }
}

