/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsRequest;
import com.emc.ecs.nfsclient.nfs.NfsResponse;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.util.Calendar;

public class NfsTime
implements NfsRequest,
NfsResponse {
    private static final int DO_NOT_CHANGE_TIME = 0;
    private static final int SET_TO_SERVER_TIME = 1;
    private static final int SET_TO_CLIENT_TIME = 2;
    public static final NfsTime DO_NOT_CHANGE = new NfsTime(0L, 0);
    public static final NfsTime SET_TO_CURRENT_ON_SERVER = new NfsTime(0L, 1);
    private long seconds;
    private long nanoseconds;
    private final int _timeSettingType;

    public NfsTime() {
        this(Calendar.getInstance().getTimeInMillis());
    }

    public NfsTime(long milliseconds) {
        this(milliseconds, 2);
    }

    private NfsTime(long milliseconds, int timeSettingType) {
        this._timeSettingType = timeSettingType;
        if (2 == timeSettingType) {
            this.seconds = milliseconds / 1000L;
            this.nanoseconds = (milliseconds - this.seconds * 1000L) * 1000000L;
        } else {
            this.seconds = 0L;
            this.nanoseconds = 0L;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("timeSettingType:").append(this._timeSettingType);
        sb.append(", [seconds :").append(this.seconds);
        sb.append(" nseconds: ").append(this.nanoseconds);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void marshalling(Xdr xdr) {
        xdr.putInt(this._timeSettingType);
        if (2 == this._timeSettingType) {
            xdr.putUnsignedInt(this.seconds);
            xdr.putUnsignedInt(this.nanoseconds);
        }
    }

    @Override
    public void unmarshalling(Xdr xdr) {
        this.seconds = xdr.getUnsignedInt();
        this.nanoseconds = xdr.getUnsignedInt();
    }

    public long getTimeInMillis() {
        return this.seconds * 1000L + this.nanoseconds / 1000000L;
    }
}

