/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsRequestBase;
import com.emc.ecs.nfsclient.rpc.Credential;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.List;

public class NfsWriteRequest
extends NfsRequestBase {
    public static final int UNSTABLE = 0;
    public static final int DATA_SYNC = 1;
    public static final int FILE_SYNC = 2;
    private final long _offset;
    private final int _size;
    private final int _syncType;
    private final List<ByteBuffer> _payload;

    public NfsWriteRequest(byte[] fileHandle, long offset, List<ByteBuffer> payload, int syncType, Credential credential, int nfsVersion) throws FileNotFoundException {
        super(100003, nfsVersion, 7, credential, fileHandle);
        if (syncType < 0 || syncType > 2) {
            throw new IllegalArgumentException("Invalid syncType: " + syncType);
        }
        this._offset = offset;
        this._syncType = syncType;
        this._payload = payload;
        int payload_size = 0;
        if (this._payload != null) {
            for (ByteBuffer b : this._payload) {
                payload_size += b.remaining();
            }
        }
        this._size = payload_size;
    }

    @Override
    public void marshalling(Xdr xdr) {
        super.marshalling(xdr);
        xdr.putLong(this._offset);
        xdr.putUnsignedInt(this._size);
        xdr.putInt(this._syncType);
        if (this._payload != null) {
            xdr.putPayloads(this._payload, this._size);
        }
    }

    public String toString() {
        return this.startToString("NfsWriteRequest").append(" offset:").append(this._offset).append(" size:").append(this._size).append(" syncType:").append(this._syncType).toString();
    }

    public int getSize() {
        return this._size;
    }

    public boolean isSync() {
        return this._syncType == 2;
    }
}

