/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs.io;

import com.emc.ecs.nfsclient.nfs.NfsReadResponse;
import com.emc.ecs.nfsclient.nfs.io.NfsFile;
import java.io.IOException;
import java.io.InputStream;

public class NfsFileInputStream
extends InputStream {
    public static final int EOF = -1;
    private NfsFile<?, ?> _file;
    private long _offset;
    private final byte[] _bytes;
    private int _bytesInBuffer = 0;
    private int _currentBufferPosition = 0;
    private boolean _isEof = false;
    private boolean _closed = false;

    public NfsFileInputStream(NfsFile<?, ?> nfsFile, long offset, int maximumBufferSize) throws IOException {
        if (offset < 0L) {
            throw new IllegalArgumentException("Cannot start reading before offset 0: " + offset);
        }
        if (maximumBufferSize <= 0) {
            throw new IllegalArgumentException("Cannot have a maximum buffer size <= 0: " + maximumBufferSize);
        }
        if (!nfsFile.canRead()) {
            throw new IllegalArgumentException("The file must be readable by the client: " + nfsFile.getAbsolutePath());
        }
        this._file = nfsFile;
        this._offset = offset;
        maximumBufferSize = Math.min(maximumBufferSize, (int)Math.min(this._file.fsinfo().getFsInfo().rtmax, Integer.MAX_VALUE));
        this._bytes = this.makeBytes(maximumBufferSize);
    }

    public NfsFileInputStream(NfsFile<?, ?> nfsFile, int maximumBufferSize) throws IOException {
        this(nfsFile, 0L, maximumBufferSize);
    }

    public NfsFileInputStream(NfsFile<?, ?> nfsFile) throws IOException {
        this(nfsFile, (int)Math.min(nfsFile.fsinfo().getFsInfo().rtpref, Integer.MAX_VALUE));
    }

    private byte[] makeBytes(int maximumBufferSize) throws IOException {
        int bufferSize = Math.min((int)Math.min(this._file.length() - this._offset, Integer.MAX_VALUE), maximumBufferSize);
        if (bufferSize == 0) {
            this._isEof = true;
        }
        return new byte[bufferSize];
    }

    @Override
    public int available() throws IOException {
        this.checkForClosed();
        return (int)(this._file.length() - this._offset + (long)this.bytesLeftInBuffer());
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
        super.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int bytesRead = this.read(b, 0, 1);
        if (bytesRead == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int furtherBytesRead;
        this.checkForClosed();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.loadBytesAsNeeded();
        int bytesImmediatelyAvailable = this.bytesLeftInBuffer();
        if (len <= bytesImmediatelyAvailable) {
            System.arraycopy(this._bytes, this._currentBufferPosition, b, off, len);
            this._currentBufferPosition += len;
            return len;
        }
        int bytesRead = -1;
        if (bytesImmediatelyAvailable > 0 && (bytesRead = this.read(b, off, bytesImmediatelyAvailable)) != -1 && (furtherBytesRead = this.read(b, off + bytesRead, len - bytesRead)) != -1) {
            bytesRead += furtherBytesRead;
        }
        return bytesRead;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkForClosed();
        super.reset();
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        this.checkForClosed();
        long bytesSkipped = 0L;
        while (bytesToSkip > (long)this.bytesLeftInBuffer()) {
            bytesSkipped += (long)this.bytesLeftInBuffer();
            bytesToSkip -= (long)this.bytesLeftInBuffer();
            this._currentBufferPosition = this._bytesInBuffer;
            if (this._isEof) break;
            this.loadBytesAsNeeded();
        }
        if (bytesToSkip > 0L && bytesToSkip <= (long)this.bytesLeftInBuffer()) {
            this._currentBufferPosition += (int)bytesToSkip;
            bytesSkipped += (long)((int)bytesToSkip);
        }
        return bytesSkipped;
    }

    private int bytesLeftInBuffer() {
        return this._bytesInBuffer - this._currentBufferPosition;
    }

    private void checkForClosed() throws IOException {
        if (this._closed) {
            throw new IOException("This stream has been closed.");
        }
    }

    private void loadBytesAsNeeded() throws IOException {
        if (this.available() <= 0) {
            this._isEof = true;
        }
        while (!this._isEof && this.bytesLeftInBuffer() <= 0) {
            this._currentBufferPosition = 0;
            NfsReadResponse response = this._file.read(this._offset, this._bytes.length, this._bytes, this._currentBufferPosition);
            this._bytesInBuffer = response.getBytesRead();
            this._offset += (long)this._bytesInBuffer;
            this._isEof = response.isEof();
        }
    }
}

