/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.network;

import com.emc.ecs.nfsclient.rpc.Xdr;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordMarkingUtil {
    private static final int LAST_FRAG = Integer.MIN_VALUE;
    private static final int SIZE_MASK = Integer.MAX_VALUE;
    private static final int MTU_SIZE = 0x100000;
    private static final Logger LOG = LoggerFactory.getLogger(RecordMarkingUtil.class);

    static void putRecordMarkingAndSend(Channel channel, Xdr rpcRequest) {
        LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
        buffers.add(ByteBuffer.wrap(rpcRequest.getBuffer(), 0, rpcRequest.getOffset()));
        if (rpcRequest.getPayloads() != null) {
            buffers.addAll(rpcRequest.getPayloads());
        }
        ArrayList<ByteBuffer> outBuffers = new ArrayList<ByteBuffer>();
        int bytesToWrite = 0;
        int remainingBuffers = buffers.size();
        boolean isLast = false;
        for (ByteBuffer buffer : buffers) {
            if (bytesToWrite + buffer.remaining() > 0x100000) {
                if (outBuffers.isEmpty()) {
                    LOG.error("too big single byte buffer {}", (Object)buffer.remaining());
                    throw new IllegalArgumentException(String.format("too big single byte buffer %d", buffer.remaining()));
                }
                RecordMarkingUtil.sendBuffers(channel, bytesToWrite, outBuffers, isLast);
                bytesToWrite = 0;
                outBuffers.clear();
            }
            outBuffers.add(buffer);
            bytesToWrite += buffer.remaining();
            isLast = --remainingBuffers == 0;
        }
        if (!outBuffers.isEmpty()) {
            RecordMarkingUtil.sendBuffers(channel, bytesToWrite, outBuffers, true);
        }
    }

    static Xdr removeRecordMarking(byte[] bytes) {
        Xdr toReturn = new Xdr(bytes.length);
        Xdr input = new Xdr(bytes);
        boolean lastFragment = false;
        input.setOffset(0);
        int inputOff = input.getOffset();
        while (!lastFragment) {
            long fragSize = input.getUnsignedInt();
            lastFragment = RecordMarkingUtil.isLastFragment(fragSize);
            fragSize = RecordMarkingUtil.maskFragmentSize(fragSize);
            toReturn.putBytes(input.getBuffer(), input.getOffset(), (int)fragSize);
            inputOff = (int)((long)inputOff + fragSize);
            input.setOffset(inputOff);
        }
        int off = toReturn.getOffset();
        toReturn.setOffset(0);
        int xid = toReturn.getInt();
        toReturn.setXid(xid);
        toReturn.setOffset(off);
        return toReturn;
    }

    private static void sendBuffers(Channel channel, int bytesToWrite, List<ByteBuffer> outBuffers, boolean isLast) {
        ByteBuffer recSizeBuf = ByteBuffer.allocate(4);
        if (isLast) {
            recSizeBuf.putInt(Integer.MIN_VALUE | bytesToWrite);
        } else {
            recSizeBuf.putInt(bytesToWrite);
        }
        recSizeBuf.rewind();
        outBuffers.add(0, recSizeBuf);
        ByteBuffer[] outArray = outBuffers.toArray(new ByteBuffer[outBuffers.size()]);
        ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer((ByteBuffer[])outArray);
        channel.write((Object)channelBuffer);
    }

    static boolean isLastFragment(long fragmentSize) {
        return (fragmentSize & Integer.MIN_VALUE) != 0L;
    }

    static long maskFragmentSize(long fragmentSize) {
        return fragmentSize & Integer.MAX_VALUE;
    }

    private RecordMarkingUtil() {
        throw new NotImplementedException("No class instances should be needed.");
    }
}

