/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsResponseBase;
import com.emc.ecs.nfsclient.rpc.RpcException;
import com.emc.ecs.nfsclient.rpc.Xdr;

public class NfsReadResponse
extends NfsResponseBase {
    private int _bytesRead;
    private boolean _eof;
    private byte[] _bytes;
    private int _position;

    public NfsReadResponse(byte[] bytes, int position, int nfsVersion) {
        this._bytes = bytes;
        this._position = position;
    }

    @Override
    public void unmarshalling(Xdr xdr) throws RpcException {
        super.unmarshalling(xdr);
        this.unmarshallingAttributes(xdr);
        if (this.stateIsOk()) {
            this._bytesRead = xdr.getInt();
            this._eof = xdr.getBoolean();
            if (this._bytes == null) {
                this._bytes = new byte[this._bytesRead];
                this._position = 0;
            }
            xdr.getBytes(xdr.getInt(), this._bytes, this._position);
        }
    }

    public int getBytesRead() {
        return this._bytesRead;
    }

    public boolean isEof() {
        return this._eof;
    }

    public byte[] getBytes() {
        return this._bytes == null ? null : (byte[])this._bytes.clone();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("read-response");
        sb.append(" bytes-read:");
        sb.append(String.valueOf(this._bytesRead));
        sb.append(" eof:");
        sb.append(String.valueOf(this._eof));
        sb.append(" [").append(super.toString()).append("]");
        return sb.toString();
    }
}

