/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsRequestBase;
import com.emc.ecs.nfsclient.nfs.NfsSetAttributes;
import com.emc.ecs.nfsclient.nfs.NfsTime;
import com.emc.ecs.nfsclient.rpc.Credential;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.io.FileNotFoundException;

public class NfsSetAttrRequest
extends NfsRequestBase {
    private final NfsSetAttributes _attributes;
    private final NfsTime _guardTime;

    public NfsSetAttrRequest(byte[] fileHandle, NfsSetAttributes attributes, NfsTime guardTime, Credential credential, int nfsVersion) throws FileNotFoundException {
        super(100003, nfsVersion, 2, credential, fileHandle);
        this._attributes = attributes;
        if (guardTime != null && !guardTime.isBareTime()) {
            throw new IllegalArgumentException("The guard time cannot be a time setting time");
        }
        this._guardTime = guardTime;
    }

    @Override
    public void marshalling(Xdr xdr) {
        super.marshalling(xdr);
        this._attributes.marshalling(xdr);
        if (this._guardTime == null) {
            xdr.putBoolean(false);
        } else {
            xdr.putBoolean(true);
            this._guardTime.marshalling(xdr);
        }
    }

    public String toString() {
        return this.startToString("NfsSetAttrRequest").append(" attributes:").append(this._attributes.toString()).toString();
    }
}

