/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs.io;

import com.emc.ecs.nfsclient.nfs.NfsCreateMode;
import com.emc.ecs.nfsclient.nfs.NfsSetAttributes;
import com.emc.ecs.nfsclient.nfs.NfsWriteResponse;
import com.emc.ecs.nfsclient.nfs.io.NfsFile;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NfsFileOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(NfsFileOutputStream.class);
    private NfsFile<?, ?> _nfsFile;
    private long _offset;
    private long _currentOffset;
    private final int _syncType;
    private final byte[] _buffer;
    private int _bufferOffset = 0;
    private boolean _closed = false;

    public NfsFileOutputStream(NfsFile<?, ?> nfsFile) throws IOException {
        this(nfsFile, 0L, 2);
    }

    public NfsFileOutputStream(NfsFile<?, ?> nfsFile, int syncType) throws IOException {
        this(nfsFile, 0L, syncType);
    }

    public NfsFileOutputStream(NfsFile<?, ?> nfsFile, long offset, int syncType) throws IOException {
        if (offset < 0L) {
            throw new IllegalArgumentException("Cannot start writing before offset 0: " + offset);
        }
        switch (syncType) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The value of syncType is undefined: " + syncType);
            }
        }
        this._nfsFile = nfsFile;
        if (this._nfsFile.exists()) {
            if (!this._nfsFile.canExtend() || !this._nfsFile.canModify()) {
                throw new IllegalArgumentException("The file must be writable by the client: " + nfsFile.getAbsolutePath());
            }
        } else {
            NfsSetAttributes attributes = new NfsSetAttributes();
            attributes.setMode(384L);
            this._nfsFile.create(NfsCreateMode.GUARDED, attributes, null);
        }
        this._offset = offset;
        this._currentOffset = offset;
        this._syncType = syncType;
        this._buffer = new byte[(int)Math.min(this._nfsFile.fsinfo().getFsInfo().wtpref, Integer.MAX_VALUE)];
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            try {
                this.flush();
            }
            catch (Throwable t) {
                LOG.debug(t.getMessage(), t);
            }
            this._closed = true;
            super.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkForClosed();
        this.writeBufferToFile();
        if (this._currentOffset > this._offset) {
            this._nfsFile.commit(this._offset, (int)(this._currentOffset - this._offset));
            this._offset = this._currentOffset;
        }
        super.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkForClosed();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (len > this.bytesLeftInBuffer()) {
            int bytesToWrite = this.bytesLeftInBuffer();
            this.write(b, off, bytesToWrite);
            this.write(b, off + bytesToWrite, len - bytesToWrite);
        } else {
            System.arraycopy(b, off, this._buffer, this._bufferOffset, len);
            this._bufferOffset += len;
            if (this.bytesLeftInBuffer() == 0) {
                this.writeBufferToFile();
            }
        }
    }

    private int bytesLeftInBuffer() {
        return this._buffer.length - this._bufferOffset;
    }

    private void checkForClosed() throws IOException {
        if (this._closed) {
            throw new IOException("This stream has been closed.");
        }
    }

    private void writeBufferToFile() throws IOException {
        if (this._bufferOffset > 0) {
            ArrayList<ByteBuffer> payload = new ArrayList<ByteBuffer>(1);
            payload.add(ByteBuffer.wrap(this._buffer, 0, this._bufferOffset));
            NfsWriteResponse response = this._nfsFile.write(this._currentOffset, payload, this._syncType);
            int bytesWritten = response.getCount();
            this._currentOffset += (long)bytesWritten;
            this._bufferOffset -= bytesWritten;
            if (0 != this._bufferOffset) {
                System.arraycopy(this._buffer, bytesWritten, this._buffer, 0, this._bufferOffset);
            }
        }
    }
}

