/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs.nfs3;

import com.emc.ecs.nfsclient.mount.MountException;
import com.emc.ecs.nfsclient.mount.MountRequest;
import com.emc.ecs.nfsclient.mount.MountResponse;
import com.emc.ecs.nfsclient.mount.MountStatus;
import com.emc.ecs.nfsclient.mount.UnmountRequest;
import com.emc.ecs.nfsclient.network.NetMgr;
import com.emc.ecs.nfsclient.nfs.Nfs;
import com.emc.ecs.nfsclient.nfs.NfsAccessRequest;
import com.emc.ecs.nfsclient.nfs.NfsCommitRequest;
import com.emc.ecs.nfsclient.nfs.NfsCreateMode;
import com.emc.ecs.nfsclient.nfs.NfsCreateRequest;
import com.emc.ecs.nfsclient.nfs.NfsDirectoryEntry;
import com.emc.ecs.nfsclient.nfs.NfsDirectoryPlusEntry;
import com.emc.ecs.nfsclient.nfs.NfsException;
import com.emc.ecs.nfsclient.nfs.NfsFsInfo;
import com.emc.ecs.nfsclient.nfs.NfsFsInfoRequest;
import com.emc.ecs.nfsclient.nfs.NfsFsStat;
import com.emc.ecs.nfsclient.nfs.NfsFsStatRequest;
import com.emc.ecs.nfsclient.nfs.NfsGetAttrRequest;
import com.emc.ecs.nfsclient.nfs.NfsLinkRequest;
import com.emc.ecs.nfsclient.nfs.NfsLookupRequest;
import com.emc.ecs.nfsclient.nfs.NfsMkdirRequest;
import com.emc.ecs.nfsclient.nfs.NfsMknodRequest;
import com.emc.ecs.nfsclient.nfs.NfsPathconfRequest;
import com.emc.ecs.nfsclient.nfs.NfsReadRequest;
import com.emc.ecs.nfsclient.nfs.NfsReaddirRequest;
import com.emc.ecs.nfsclient.nfs.NfsReaddirplusRequest;
import com.emc.ecs.nfsclient.nfs.NfsReadlinkRequest;
import com.emc.ecs.nfsclient.nfs.NfsRemoveRequest;
import com.emc.ecs.nfsclient.nfs.NfsRenameRequest;
import com.emc.ecs.nfsclient.nfs.NfsRequestBase;
import com.emc.ecs.nfsclient.nfs.NfsResponseBase;
import com.emc.ecs.nfsclient.nfs.NfsResponseHandler;
import com.emc.ecs.nfsclient.nfs.NfsRmdirRequest;
import com.emc.ecs.nfsclient.nfs.NfsSetAttrRequest;
import com.emc.ecs.nfsclient.nfs.NfsSetAttributes;
import com.emc.ecs.nfsclient.nfs.NfsStatus;
import com.emc.ecs.nfsclient.nfs.NfsSymlinkRequest;
import com.emc.ecs.nfsclient.nfs.NfsTime;
import com.emc.ecs.nfsclient.nfs.NfsType;
import com.emc.ecs.nfsclient.nfs.NfsWriteRequest;
import com.emc.ecs.nfsclient.nfs.io.Nfs3File;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3AccessRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3AccessResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3CommitRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3CommitResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3CreateRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3CreateResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3FsInfoRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3FsInfoResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3FsStatRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3FsStatResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3GetAttrRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3GetAttrResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3LinkRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3LinkResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3LookupRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3LookupResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3MkdirRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3MkdirResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3MknodRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3MknodResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3PathconfRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3PathconfResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3ReadRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3ReadResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3ReaddirRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3ReaddirResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3ReaddirplusRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3ReaddirplusResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3ReadlinkRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3ReadlinkResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3RemoveRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3RemoveResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3RenameRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3RenameResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3RmdirRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3RmdirResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3SetAttrRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3SetAttrResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3SymlinkRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3SymlinkResponse;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3WriteRequest;
import com.emc.ecs.nfsclient.nfs.nfs3.Nfs3WriteResponse;
import com.emc.ecs.nfsclient.portmap.Portmapper;
import com.emc.ecs.nfsclient.rpc.Credential;
import com.emc.ecs.nfsclient.rpc.CredentialUnix;
import com.emc.ecs.nfsclient.rpc.RejectStatus;
import com.emc.ecs.nfsclient.rpc.RpcException;
import com.emc.ecs.nfsclient.rpc.RpcRequest;
import com.emc.ecs.nfsclient.rpc.RpcResponseHandler;
import com.emc.ecs.nfsclient.rpc.RpcStatus;
import com.emc.ecs.nfsclient.rpc.RpcWrapper;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nfs3
implements Nfs<Nfs3File> {
    private static final Logger LOG = LoggerFactory.getLogger(Nfs3.class);
    public static final int VERSION = 3;
    public static final int NFS_TIMEOUT = 10;
    public static final int MAXIMUM_NFS_REQUEST_SIZE = 8192;
    private final String _server;
    private int _port = 0;
    private final String _exportedPath;
    private byte[] _rootFileHandle = null;
    private final int _maximumRetries;
    private final int DEFAULT_WAIT_TIME_MILLIS = 1000;
    private final int _retryWait = 1000;
    private final Lock _prepareLock = new ReentrantLock();
    private Credential _credential = new CredentialUnix();
    private final RpcWrapper<NfsRequestBase, NfsResponseBase> _rpcWrapper;
    private static final int MOUNT_RPC_TIMEOUT = 10;
    private static final int MOUNT_MAX_RETRIES = 2;
    private static final int MOUNT_MAX_REQUEST_SIZE = 8192;

    public Nfs3(String server, String exportedPath, byte[] rootFileHandle, int maximumRetries) throws IOException {
        this(server, exportedPath, rootFileHandle, null, maximumRetries);
    }

    public Nfs3(String server, String exportedPath, Credential credential, int maximumRetries) throws IOException {
        this(server, exportedPath, null, credential, maximumRetries);
    }

    public Nfs3(String absolutePath, int uid, int gid, int maximumRetries) throws IOException {
        this(absolutePath, new CredentialUnix(uid, gid, null), maximumRetries);
    }

    public Nfs3(String absolutePath, Credential credential, int maximumRetries) throws IOException {
        this(Nfs3.getServer(absolutePath), Nfs3.getExportedPath(absolutePath), credential, maximumRetries);
    }

    public Nfs3(String server, String exportedPath, byte[] rootFileHandle, Credential credential, int maximumRetries) throws IOException {
        this.checkForBlank(server, "server");
        this.checkForBlank(exportedPath, "exportedPath");
        if (maximumRetries <= 0) {
            throw new IllegalArgumentException("maxRetry must be positive.");
        }
        this._server = server;
        this._exportedPath = exportedPath;
        this._maximumRetries = maximumRetries;
        if (credential != null) {
            this._credential = credential;
        }
        this._rpcWrapper = new RpcWrapper(this._server, this._port, 1000, this._maximumRetries, 8192, 10);
        if (rootFileHandle == null) {
            this.prepareRootFhAndNfsPort();
        } else {
            this._rootFileHandle = (byte[])rootFileHandle.clone();
            this._port = this.getNfsPortFromServer();
            this._rpcWrapper.setPort(this._port);
        }
    }

    private void checkForBlank(String value, String name) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    private static String getServer(String absolutePath) {
        int index = absolutePath.indexOf(":");
        return absolutePath.substring(0, Math.max(index, 0));
    }

    private static String getExportedPath(String absolutePath) {
        int index = absolutePath.indexOf(":");
        return absolutePath.substring(index + 1);
    }

    private void prepareRootFhAndNfsPort() throws IOException {
        if (!this._prepareLock.tryLock()) {
            return;
        }
        try {
            this._port = this.getNfsPortFromServer();
            this._rpcWrapper.setPort(this._port);
            this._rootFileHandle = this.lookupRootHandle();
        }
        finally {
            this._prepareLock.unlock();
        }
    }

    byte[] lookupRootHandle() throws IOException {
        int portOfMountService = Portmapper.queryPortFromPortMap(100005, 3, this._server);
        MountResponse response = null;
        MountRequest request = new MountRequest(3, this._exportedPath, this._credential);
        boolean usePrivilegedPort = false;
        for (int i = 0; i < 2; ++i) {
            try {
                Xdr mountXdr = new Xdr(8192);
                request.marshalling(mountXdr);
                response = new MountResponse(3);
                if (usePrivilegedPort) {
                    LOG.debug("Mounting with privileged port - attempt with unprivileged failed with an authentication error.");
                }
                response.unmarshalling(NetMgr.getInstance().sendAndWait(this._server, portOfMountService, usePrivilegedPort, mountXdr, 10));
                int status = response.getMountStatus();
                if (status == MountStatus.MNT3_OK.getValue()) continue;
                String msg = String.format("mount failure, server: %s, export: %s, nfs version: %s, returned state: %s", this._server, this._exportedPath, 3, status);
                throw new MountException(MountStatus.fromValue(status), msg);
            }
            catch (RpcException e) {
                usePrivilegedPort = this.handleRpcException(e, i);
            }
        }
        UnmountRequest unmountRequest = new UnmountRequest(3, this._exportedPath, this._credential);
        for (int i = 0; i < 2; ++i) {
            try {
                Xdr unmountXdr = new Xdr(8192);
                unmountRequest.marshalling(unmountXdr);
                NetMgr.getInstance().sendAndWait(this._server, portOfMountService, usePrivilegedPort, unmountXdr, 10);
                continue;
            }
            catch (RpcException e) {
                if (i + 1 >= 2) continue;
                LOG.warn(String.format("unmount failure, server: %s, export: %s, nfs version: %s", this._server, this._exportedPath, 3), (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            int[] authenticationFlavors = response.getAuthenticationFlavors();
            LOG.debug("nfs server {}:{} supports auth mode {}", new Object[]{this._server, this._exportedPath, Arrays.toString(authenticationFlavors)});
        }
        return response.getRootFileHandle();
    }

    private boolean handleRpcException(RpcException e, int attemptNumber) throws IOException {
        boolean retry;
        boolean tryPrivilegedPort = e.getStatus().equals(RejectStatus.AUTH_ERROR);
        boolean networkError = e.getStatus().equals(RpcStatus.NETWORK_ERROR);
        boolean bl = retry = (tryPrivilegedPort || networkError) && attemptNumber + 1 < 2;
        if (!retry) {
            String messageStart = networkError ? "network" : "rpc";
            String msg = String.format("%s error, server: %s, export: %s, RPC error: %s", messageStart, this._server, this._exportedPath, e.getMessage());
            throw new MountException(MountStatus.MNT3ERR_IO, msg, e);
        }
        System.out.println("retry " + (attemptNumber + 1));
        if (tryPrivilegedPort) {
            LOG.info("Next try will be with a privileged port.");
        }
        return tryPrivilegedPort;
    }

    private int getNfsPortFromServer() throws IOException {
        return Portmapper.queryPortFromPortMap(100003, 3, this._server);
    }

    @Override
    public void disableSudo() throws IOException {
        this._credential = new CredentialUnix();
    }

    @Override
    public void enableSudo(int uid, int gid) {
        this._credential = new CredentialUnix(uid, gid, null);
    }

    @Override
    public Credential getCredential() {
        return this._credential;
    }

    @Override
    public String getExportedPath() {
        return this._exportedPath;
    }

    @Override
    public Nfs3File newFile(String path) throws IOException {
        return new Nfs3File(this, path);
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public byte[] getRootFileHandle() {
        return (byte[])this._rootFileHandle.clone();
    }

    @Override
    public String getServer() {
        return this._server;
    }

    @Override
    public Xdr nullCall() throws IOException {
        Xdr xdr = new Xdr(8192);
        new RpcRequest(100003, 3, 0, this._credential){

            @Override
            public String getErrorMessage() {
                throw new NotImplementedException("This should never be used for a NULL call.");
            }
        }.marshalling(xdr);
        return this._rpcWrapper.callRpc(this._rpcWrapper.chooseIP(this._server.getBytes(RpcRequest.CHARSET)), xdr, false);
    }

    @Override
    public Nfs3GetAttrRequest makeGetAttrRequest(byte[] fileHandle) throws FileNotFoundException {
        return new Nfs3GetAttrRequest(fileHandle, this._credential);
    }

    @Override
    public Nfs3GetAttrResponse getAttr(NfsGetAttrRequest request) throws IOException {
        Nfs3GetAttrResponse response = new Nfs3GetAttrResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3GetAttrResponse wrapped_getAttr(NfsGetAttrRequest request) throws IOException {
        NfsResponseHandler<Nfs3GetAttrResponse> responseHandler = new NfsResponseHandler<Nfs3GetAttrResponse>(){

            @Override
            protected Nfs3GetAttrResponse makeNewResponse() {
                return new Nfs3GetAttrResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3GetAttrResponse)responseHandler.getResponse();
    }

    @Override
    public NfsSetAttrRequest makeSetAttrRequest(byte[] fileHandle, NfsSetAttributes attributes, NfsTime guardTime) throws FileNotFoundException {
        return new Nfs3SetAttrRequest(fileHandle, attributes, guardTime, this._credential);
    }

    @Override
    public Nfs3SetAttrResponse setAttr(NfsSetAttrRequest request) throws IOException {
        Nfs3SetAttrResponse response = new Nfs3SetAttrResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3SetAttrResponse wrapped_setAttr(NfsSetAttrRequest request) throws IOException {
        NfsResponseHandler<Nfs3SetAttrResponse> responseHandler = new NfsResponseHandler<Nfs3SetAttrResponse>(){

            @Override
            protected Nfs3SetAttrResponse makeNewResponse() {
                return new Nfs3SetAttrResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3SetAttrResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3LookupRequest makeLookupRequest(byte[] fileHandle, String name) throws FileNotFoundException {
        return new Nfs3LookupRequest(fileHandle, name, this._credential);
    }

    @Override
    public Nfs3LookupResponse getLookup(NfsLookupRequest request) throws IOException {
        Nfs3LookupResponse response = new Nfs3LookupResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3LookupResponse wrapped_getLookup(NfsLookupRequest request) throws IOException {
        NfsResponseHandler<Nfs3LookupResponse> responseHandler = new NfsResponseHandler<Nfs3LookupResponse>(){

            @Override
            protected Nfs3LookupResponse makeNewResponse() {
                return new Nfs3LookupResponse();
            }

            @Override
            public void checkResponse(RpcRequest request) throws IOException {
                if (((Nfs3LookupResponse)this.getResponse()).getState() == NfsStatus.NFS3ERR_BADHANDLE.getValue() && ((NfsLookupRequest)request).getFileHandle() == Nfs3.this._rootFileHandle) {
                    Nfs3.this.prepareRootFhAndNfsPort();
                }
                super.checkResponse(request);
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3LookupResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3AccessRequest makeAccessRequest(byte[] fileHandle, long accessToCheck) throws FileNotFoundException {
        return new Nfs3AccessRequest(fileHandle, accessToCheck, this._credential);
    }

    @Override
    public Nfs3AccessResponse getAccess(NfsAccessRequest request) throws IOException {
        Nfs3AccessResponse response = new Nfs3AccessResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3AccessResponse wrapped_getAccess(NfsAccessRequest request) throws IOException {
        NfsResponseHandler<Nfs3AccessResponse> responseHandler = new NfsResponseHandler<Nfs3AccessResponse>(){

            @Override
            protected Nfs3AccessResponse makeNewResponse() {
                return new Nfs3AccessResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3AccessResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3ReadlinkRequest makeReadlinkRequest(byte[] fileHandle) throws FileNotFoundException {
        return new Nfs3ReadlinkRequest(fileHandle, this._credential);
    }

    @Override
    public Nfs3ReadlinkResponse getReadlink(NfsReadlinkRequest request) throws IOException {
        Nfs3ReadlinkResponse response = new Nfs3ReadlinkResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3ReadlinkResponse wrapped_getReadlink(NfsReadlinkRequest request) throws IOException {
        NfsResponseHandler<Nfs3ReadlinkResponse> responseHandler = new NfsResponseHandler<Nfs3ReadlinkResponse>(){

            @Override
            protected Nfs3ReadlinkResponse makeNewResponse() {
                return new Nfs3ReadlinkResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3ReadlinkResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3ReadRequest makeReadRequest(byte[] fileHandle, long offset, int size) throws FileNotFoundException {
        return new Nfs3ReadRequest(fileHandle, offset, size, this._credential);
    }

    @Override
    public Nfs3ReadResponse getRead(NfsReadRequest request, byte[] bytes, int position) throws IOException {
        Nfs3ReadResponse response = new Nfs3ReadResponse(bytes, position);
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3ReadResponse wrapped_getRead(NfsReadRequest request, final byte[] bytes, final int position) throws IOException {
        NfsResponseHandler<Nfs3ReadResponse> responseHandler = new NfsResponseHandler<Nfs3ReadResponse>(){

            @Override
            protected Nfs3ReadResponse makeNewResponse() {
                return new Nfs3ReadResponse(bytes, position);
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3ReadResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3WriteRequest makeWriteRequest(byte[] fileHandle, long offset, List<ByteBuffer> payload, int syncType) throws FileNotFoundException {
        return new Nfs3WriteRequest(fileHandle, offset, payload, syncType, this._credential);
    }

    @Override
    public Nfs3WriteResponse sendWrite(NfsWriteRequest request) throws IOException {
        Nfs3WriteResponse response = new Nfs3WriteResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3WriteResponse wrapped_sendWrite(NfsWriteRequest request) throws IOException {
        String ip = request.isSync() ? this._rpcWrapper.chooseIP(request.getIpKey()) : this._server;
        NfsResponseHandler<Nfs3WriteResponse> responseHandler = new NfsResponseHandler<Nfs3WriteResponse>(){

            @Override
            protected Nfs3WriteResponse makeNewResponse() {
                return new Nfs3WriteResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler, ip);
        return (Nfs3WriteResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3WriteResponse wrapped_sendWrite(NfsWriteRequest request, final Long verifier) throws IOException {
        String ip = request.isSync() ? this._rpcWrapper.chooseIP(request.getIpKey()) : this._server;
        NfsResponseHandler<Nfs3WriteResponse> responseHandler = new NfsResponseHandler<Nfs3WriteResponse>(){

            @Override
            protected Nfs3WriteResponse makeNewResponse() {
                return new Nfs3WriteResponse();
            }

            @Override
            public void checkResponse(RpcRequest request) throws IOException {
                super.checkResponse(request);
                if (!((NfsWriteRequest)request).isSync() && verifier != null && ((Nfs3WriteResponse)this.getResponse()).getVerf() != verifier.longValue()) {
                    throw new NfsException(NfsStatus.NFS3ERR_SERVERFAULT, "server restart detected");
                }
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler, ip);
        return (Nfs3WriteResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3CreateRequest makeCreateRequest(NfsCreateMode createMode, byte[] parentDirectoryFileHandle, String name, NfsSetAttributes attributes, byte[] verifier) throws FileNotFoundException {
        return new Nfs3CreateRequest(createMode, parentDirectoryFileHandle, name, attributes, verifier, this._credential);
    }

    @Override
    public Nfs3CreateResponse sendCreate(NfsCreateRequest request) throws IOException {
        Nfs3CreateResponse response = new Nfs3CreateResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3CreateResponse wrapped_sendCreate(NfsCreateRequest request) throws IOException {
        NfsResponseHandler<Nfs3CreateResponse> responseHandler = new NfsResponseHandler<Nfs3CreateResponse>(){

            @Override
            protected Nfs3CreateResponse makeNewResponse() {
                return new Nfs3CreateResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3CreateResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3MkdirRequest makeMkdirRequest(byte[] parentDirectoryFileHandle, String name, NfsSetAttributes attributes) throws FileNotFoundException {
        return new Nfs3MkdirRequest(parentDirectoryFileHandle, name, attributes, this._credential);
    }

    @Override
    public Nfs3MkdirResponse sendMkdir(NfsMkdirRequest request) throws IOException {
        Nfs3MkdirResponse response = new Nfs3MkdirResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3MkdirResponse wrapped_sendMkdir(NfsMkdirRequest request) throws IOException {
        NfsResponseHandler<Nfs3MkdirResponse> responseHandler = new NfsResponseHandler<Nfs3MkdirResponse>(){

            @Override
            protected Nfs3MkdirResponse makeNewResponse() {
                return new Nfs3MkdirResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3MkdirResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3SymlinkRequest makeSymlinkRequest(String symbolicLinkData, byte[] parentDirectoryFileHandle, String name, NfsSetAttributes attributes) throws FileNotFoundException {
        return new Nfs3SymlinkRequest(symbolicLinkData, parentDirectoryFileHandle, name, attributes, this._credential);
    }

    @Override
    public Nfs3SymlinkResponse sendSymlink(NfsSymlinkRequest request) throws IOException {
        Nfs3SymlinkResponse response = new Nfs3SymlinkResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3SymlinkResponse wrapped_sendSymlink(NfsSymlinkRequest request) throws IOException {
        NfsResponseHandler<Nfs3SymlinkResponse> responseHandler = new NfsResponseHandler<Nfs3SymlinkResponse>(){

            @Override
            protected Nfs3SymlinkResponse makeNewResponse() {
                return new Nfs3SymlinkResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3SymlinkResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3MknodRequest makeMknodRequest(byte[] parentDirectoryFileHandle, String name, NfsType type, NfsSetAttributes attributes, long[] rdev) throws FileNotFoundException {
        return new Nfs3MknodRequest(parentDirectoryFileHandle, name, type, attributes, rdev, this._credential);
    }

    @Override
    public Nfs3MknodResponse sendMknod(NfsMknodRequest request) throws IOException {
        Nfs3MknodResponse response = new Nfs3MknodResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3MknodResponse wrapped_sendMknod(NfsMknodRequest request) throws IOException {
        NfsResponseHandler<Nfs3MknodResponse> responseHandler = new NfsResponseHandler<Nfs3MknodResponse>(){

            @Override
            protected Nfs3MknodResponse makeNewResponse() {
                return new Nfs3MknodResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3MknodResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3RemoveRequest makeRemoveRequest(byte[] parentDirectoryFileHandle, String name) throws FileNotFoundException {
        return new Nfs3RemoveRequest(parentDirectoryFileHandle, name, this._credential);
    }

    @Override
    public Nfs3RemoveResponse sendRemove(NfsRemoveRequest request) throws IOException {
        Nfs3RemoveResponse response = new Nfs3RemoveResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3RemoveResponse wrapped_sendRemove(NfsRemoveRequest request) throws IOException {
        NfsResponseHandler<Nfs3RemoveResponse> responseHandler = new NfsResponseHandler<Nfs3RemoveResponse>(){

            @Override
            protected Nfs3RemoveResponse makeNewResponse() {
                return new Nfs3RemoveResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3RemoveResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3RmdirRequest makeRmdirRequest(byte[] parentDirectoryFileHandle, String name) throws FileNotFoundException {
        return new Nfs3RmdirRequest(parentDirectoryFileHandle, name, this._credential);
    }

    @Override
    public Nfs3RmdirResponse sendRmdir(NfsRmdirRequest request) throws IOException {
        Nfs3RmdirResponse response = new Nfs3RmdirResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3RmdirResponse wrapped_sendRmdir(NfsRmdirRequest request) throws IOException {
        NfsResponseHandler<Nfs3RmdirResponse> responseHandler = new NfsResponseHandler<Nfs3RmdirResponse>(){

            @Override
            protected Nfs3RmdirResponse makeNewResponse() {
                return new Nfs3RmdirResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3RmdirResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3RenameRequest makeRenameRequest(byte[] fromDirectoryFileHandle, String fromName, byte[] toDirectoryFileHandle, String toName) throws FileNotFoundException {
        return new Nfs3RenameRequest(fromDirectoryFileHandle, fromName, toDirectoryFileHandle, toName, this._credential);
    }

    @Override
    public Nfs3RenameResponse sendRename(NfsRenameRequest request) throws IOException {
        Nfs3RenameResponse response = new Nfs3RenameResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3RenameResponse wrapped_sendRename(NfsRenameRequest request) throws IOException {
        NfsResponseHandler<Nfs3RenameResponse> responseHandler = new NfsResponseHandler<Nfs3RenameResponse>(){

            @Override
            protected Nfs3RenameResponse makeNewResponse() {
                return new Nfs3RenameResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3RenameResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3LinkRequest makeLinkRequest(byte[] fileHandle, byte[] parentDirectoryFileHandle, String name) throws FileNotFoundException {
        return new Nfs3LinkRequest(fileHandle, parentDirectoryFileHandle, name, this._credential);
    }

    @Override
    public Nfs3LinkResponse sendLink(NfsLinkRequest request) throws IOException {
        Nfs3LinkResponse response = new Nfs3LinkResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3LinkResponse wrapped_sendLink(NfsLinkRequest request) throws IOException {
        NfsResponseHandler<Nfs3LinkResponse> responseHandler = new NfsResponseHandler<Nfs3LinkResponse>(){

            @Override
            protected Nfs3LinkResponse makeNewResponse() {
                return new Nfs3LinkResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3LinkResponse)responseHandler.getResponse();
    }

    @Override
    public NfsReaddirRequest makeReaddirRequest(byte[] directoryFileHandle, long cookie, long cookieverf, int count) throws FileNotFoundException {
        return new Nfs3ReaddirRequest(directoryFileHandle, cookie, cookieverf, count, this._credential);
    }

    @Override
    public Nfs3ReaddirResponse getReaddir(NfsReaddirRequest request) throws IOException {
        Nfs3ReaddirResponse response = new Nfs3ReaddirResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3ReaddirResponse wrapped_getReaddir(NfsReaddirRequest request) throws IOException {
        NfsResponseHandler<Nfs3ReaddirResponse> responseHandler = new NfsResponseHandler<Nfs3ReaddirResponse>(){

            @Override
            protected Nfs3ReaddirResponse makeNewResponse() {
                return new Nfs3ReaddirResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3ReaddirResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3ReaddirResponse wrapped_getReaddir(NfsReaddirRequest request, final List<NfsDirectoryEntry> entries) throws IOException {
        NfsResponseHandler<Nfs3ReaddirResponse> responseHandler = new NfsResponseHandler<Nfs3ReaddirResponse>(){

            @Override
            protected Nfs3ReaddirResponse makeNewResponse() {
                return new Nfs3ReaddirResponse(entries);
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3ReaddirResponse)responseHandler.getResponse();
    }

    @Override
    public NfsReaddirplusRequest makeReaddirplusRequest(byte[] directoryFileHandle, long cookie, long cookieverf, int dircount, int maxcount) throws FileNotFoundException {
        return new Nfs3ReaddirplusRequest(directoryFileHandle, cookie, cookieverf, dircount, maxcount, this._credential);
    }

    @Override
    public Nfs3ReaddirplusResponse getReaddirplus(NfsReaddirplusRequest request) throws IOException {
        Nfs3ReaddirplusResponse response = new Nfs3ReaddirplusResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3ReaddirplusResponse wrapped_getReaddirplus(NfsReaddirplusRequest request) throws IOException {
        NfsResponseHandler<Nfs3ReaddirplusResponse> responseHandler = new NfsResponseHandler<Nfs3ReaddirplusResponse>(){

            @Override
            protected Nfs3ReaddirplusResponse makeNewResponse() {
                return new Nfs3ReaddirplusResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3ReaddirplusResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3ReaddirplusResponse wrapped_getReaddirplus(NfsReaddirplusRequest request, final List<NfsDirectoryPlusEntry> entries) throws IOException {
        NfsResponseHandler<Nfs3ReaddirplusResponse> responseHandler = new NfsResponseHandler<Nfs3ReaddirplusResponse>(){

            @Override
            protected Nfs3ReaddirplusResponse makeNewResponse() {
                return new Nfs3ReaddirplusResponse(entries);
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3ReaddirplusResponse)responseHandler.getResponse();
    }

    @Override
    public NfsFsStat getNfsFsStat() throws IOException {
        return this.wrapped_getFsStat(this.makeFsStatRequest()).getFsStat();
    }

    @Override
    public Nfs3FsStatRequest makeFsStatRequest(byte[] fileHandle) throws FileNotFoundException {
        return new Nfs3FsStatRequest(fileHandle, this._credential);
    }

    @Override
    public Nfs3FsStatRequest makeFsStatRequest() throws FileNotFoundException {
        return this.makeFsStatRequest(this.getRootFileHandle());
    }

    @Override
    public Nfs3FsStatResponse getFsStat(NfsFsStatRequest request) throws IOException {
        Nfs3FsStatResponse response = new Nfs3FsStatResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3FsStatResponse wrapped_getFsStat(NfsFsStatRequest request) throws IOException {
        NfsResponseHandler<Nfs3FsStatResponse> responseHandler = new NfsResponseHandler<Nfs3FsStatResponse>(){

            @Override
            protected Nfs3FsStatResponse makeNewResponse() {
                return new Nfs3FsStatResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3FsStatResponse)responseHandler.getResponse();
    }

    @Override
    public NfsFsInfo getNfsFsInfo() throws IOException {
        return this.wrapped_getFsInfo(this.makeFsInfoRequest()).getFsInfo();
    }

    @Override
    public Nfs3FsInfoRequest makeFsInfoRequest(byte[] fileHandle) throws FileNotFoundException {
        return new Nfs3FsInfoRequest(fileHandle, this._credential);
    }

    @Override
    public Nfs3FsInfoRequest makeFsInfoRequest() throws FileNotFoundException {
        return this.makeFsInfoRequest(this.getRootFileHandle());
    }

    @Override
    public Nfs3FsInfoResponse getFsInfo(NfsFsInfoRequest request) throws IOException {
        Nfs3FsInfoResponse response = new Nfs3FsInfoResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3FsInfoResponse wrapped_getFsInfo(NfsFsInfoRequest request) throws IOException {
        NfsResponseHandler<Nfs3FsInfoResponse> responseHandler = new NfsResponseHandler<Nfs3FsInfoResponse>(){

            @Override
            protected Nfs3FsInfoResponse makeNewResponse() {
                return new Nfs3FsInfoResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3FsInfoResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3PathconfRequest makePathconfRequest(byte[] fileHandle) throws FileNotFoundException {
        return new Nfs3PathconfRequest(fileHandle, this._credential);
    }

    @Override
    public Nfs3PathconfResponse getPathconf(NfsPathconfRequest request) throws IOException {
        Nfs3PathconfResponse response = new Nfs3PathconfResponse();
        this._rpcWrapper.callRpcNaked(request, response);
        return response;
    }

    @Override
    public Nfs3PathconfResponse wrapped_getPathconf(NfsPathconfRequest request) throws IOException {
        NfsResponseHandler<Nfs3PathconfResponse> responseHandler = new NfsResponseHandler<Nfs3PathconfResponse>(){

            @Override
            protected Nfs3PathconfResponse makeNewResponse() {
                return new Nfs3PathconfResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return (Nfs3PathconfResponse)responseHandler.getResponse();
    }

    @Override
    public Nfs3CommitRequest makeCommitRequest(byte[] fileHandle, long offsetToCommit, int dataSizeToCommit) throws FileNotFoundException {
        return new Nfs3CommitRequest(fileHandle, offsetToCommit, dataSizeToCommit, this._credential);
    }

    @Override
    public Nfs3CommitResponse sendCommit(NfsCommitRequest request) throws IOException {
        Nfs3CommitResponse response = new Nfs3CommitResponse();
        this._rpcWrapper.callRpcNaked(request, response, this._server);
        return response;
    }

    @Override
    public Nfs3CommitResponse wrapped_sendCommit(NfsCommitRequest request) throws IOException {
        NfsResponseHandler<Nfs3CommitResponse> responseHandler = new NfsResponseHandler<Nfs3CommitResponse>(){

            @Override
            protected Nfs3CommitResponse makeNewResponse() {
                return new Nfs3CommitResponse();
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler, this._server);
        return (Nfs3CommitResponse)responseHandler.getResponse();
    }

    public int read(String path, byte[] fileHandle, long offset, int length, final byte[] data, final int pos, final MutableBoolean eof) throws IOException {
        Nfs3ReadRequest request = new Nfs3ReadRequest(fileHandle, offset, length, this._credential);
        NfsResponseHandler<Nfs3ReadResponse> responseHandler = new NfsResponseHandler<Nfs3ReadResponse>(){

            @Override
            protected Nfs3ReadResponse makeNewResponse() {
                return new Nfs3ReadResponse(data, pos);
            }

            @Override
            public void checkResponse(RpcRequest request) throws IOException {
                super.checkResponse(request);
                eof.setValue(((Nfs3ReadResponse)this.getResponse()).isEof());
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler);
        return ((Nfs3ReadResponse)responseHandler.getResponse()).getBytesRead();
    }

    public void fsync(String path, byte[] fh, final Long verifier) throws IOException {
        Nfs3CommitRequest request = new Nfs3CommitRequest(fh, 0L, 0, this._credential);
        NfsResponseHandler<Nfs3CommitResponse> responseHandler = new NfsResponseHandler<Nfs3CommitResponse>(){

            @Override
            protected Nfs3CommitResponse makeNewResponse() {
                return new Nfs3CommitResponse();
            }

            @Override
            public void checkResponse(RpcRequest request) throws IOException {
                super.checkResponse(request);
                if (verifier != null && ((Nfs3CommitResponse)this.getResponse()).getVerf() != verifier.longValue()) {
                    throw new NfsException(NfsStatus.NFS3ERR_SERVERFAULT, "server restart detected");
                }
            }
        };
        this._rpcWrapper.callRpcWrapped(request, (RpcResponseHandler<NfsResponseBase>)responseHandler, this._server);
    }
}

